/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.snowflakecortex;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowflakeCompletionRESTQuery {
    @Nonnull
    public String model;
    public List<Message> messages;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    public boolean stream = false;
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    public List<FunctionTool> tools;

    public static class ToolResultContent {
        public final String type = "text";
        public String text;
    }

    public static class ToolResult {
        @SerializedName(value="tool_use_id")
        public String toolUseId;
        public String name;
        public List<ToolResultContent> content = new ArrayList<ToolResultContent>();
    }

    public static class ToolResultWrapper {
        public final String type = "tool_results";
        @SerializedName(value="tool_results")
        public ToolResult result;
    }

    public static class ToolMessage
    implements Message {
        public final String role = "user";
        @Nullable
        public String content;
        @SerializedName(value="content_list")
        public List<ToolResultWrapper> contentList;
    }

    public static class ToolUse {
        @SerializedName(value="tool_use_id")
        public String toolUseId;
        public String name;
        public JsonObject input;
    }

    public static class ToolUseWrapper {
        public final String type = "tool_use";
        @SerializedName(value="tool_use")
        public ToolUse toolUse = new ToolUse();
    }

    public static class AssistantMessage
    implements Message {
        public final String role = "assistant";
        @Nullable
        public String content;
        @Nullable
        @SerializedName(value="content_list")
        public List<ToolUseWrapper> contentList;
    }

    public static class UserMessage
    implements Message {
        public final String role = "user";
        public String content;
    }

    public static class SystemMessage
    implements Message {
        public final String role = "system";
        public String content;
    }

    public static interface Message {
    }

    public static class FunctionToolDesc {
        public String type;
        public String name;
        @Nullable
        public String description;
        @Nullable
        @SerializedName(value="input_schema")
        public JsonObject inputSchema;
    }

    public static class FunctionTool {
        @SerializedName(value="tool_spec")
        public FunctionToolDesc toolSpec = new FunctionToolDesc();
    }

    public static enum ToolChoiceType {
        auto,
        required,
        tool;

    }

    public static class ToolChoice {
        public ToolChoiceType type;
    }
}

