/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.SparkConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.ColumnMetricsQueryBuilder;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkConfigurator;
import com.dataiku.dip.spark.SparkSQLConnectionPoolService;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SparkColumnMetricsEngine
extends JdbcEngine
implements ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderEngine {
    @Autowired
    private SparkSQLConnectionPoolService connectionPoolService;
    private final JdbcEngine.SparkMetricsEngineConfig config;
    private final SparkSettings sparkSettings;
    private static final Logger logger = Logger.getLogger((String)"dku.datasets.metrics.spark.column_metrics");

    public SparkColumnMetricsEngine(Dataset dataset, Partition partition, JdbcEngine.SparkMetricsEngineConfig config, SparkSettings sparkSettings) {
        super(dataset, partition);
        this.config = config;
        this.sparkSettings = sparkSettings;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException {
        logger.info((Object)("Spark metrics engine on dataset : " + this.dataset.getFullName()));
        SparkConnection datasetConnection = SparkConfigurator.configureConnectionForDatabase("default", this.config.extraConf, this.connectionPoolService);
        String datasetTableName = this.dataset.getProjectKey() + "_" + this.dataset.getName();
        datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.dataset." + this.dataset.getFullName(), datasetTableName, false));
        Partition partition = this.getPartition();
        if (partition != null) {
            datasetConnection.params.properties.add(new AbstractSQLConnection.CustomDatabaseProperty("dku.spark.sql.register.partition." + this.dataset.getFullName(), partition.id(), false));
        }
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        ColumnMetricsQueryBuilder builder = new ColumnMetricsQueryBuilder();
        return builder.buildQuery(authCtx, this, computations);
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        for (String[] row : res.rows) {
            boolean more = false;
            for (MetricComputation computation : computations) {
                ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
                more |= computer.handleResult(res.columns, row, computation);
            }
            if (more) continue;
            break;
        }
        HashMap metricsValues = Maps.newHashMap();
        for (int i = 0; i < computations.size(); ++i) {
            MetricComputation computation = computations.get(i);
            ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation computer = (ColumnMetricsQueryBuilder.ColumnMetricsQueryBuilderAggregation)((Object)computation.computer);
            metricsValues.put(computation.metric, computer.getAggregate(computation));
        }
        return metricsValues;
    }

    @Override
    public ExpressionBuilder getPartitionFilter() {
        return null;
    }

    public static class SparkColumnMetricsEngineRun
    extends MetricsEngineRun {
        public final String column;

        public SparkColumnMetricsEngineRun(String column) {
            super(MetricsEngineDesc.SparkColumnMetricsEngine);
            this.column = column;
        }

        public SparkColumnMetricsEngineRun(String column, double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.SparkColumnMetricsEngine, cost, computations, pass);
            this.column = column;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new SparkColumnMetricsEngineRun(this.column, cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return super.canMergeWith(other) && this.column.equals(((SparkColumnMetricsEngineRun)other).column);
        }
    }
}

