/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.output;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.CompressibleFormatParams;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.output.ResplittableExtensibleFileOutputWriter;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.IOException;
import java.util.List;

public class HDFSOutput
implements Output,
CanListFilesWrittenTo {
    private final HDFSProvider provider;
    private final String datasetBase;
    private final Partition partition;
    private final int splitId;
    private final int resplitFactor;
    private final String outputFormatType;
    private final FormatParams outputFormatParams;
    private final Schema outputSchema;
    private final WarningsContext warningsContext;
    private final SerializedDataset.ReadWriteOptions readWriteOptions;
    private final PartitioningScheme scheme;
    private final String projectKey;
    private final AuthCtx authCtx;

    public HDFSOutput(AuthCtx authCtx, String projectKey, HDFSProvider provider, String datasetBase, Partition targetPartition, PartitioningScheme scheme, int splitId, int resplitFactor, String outputFormatType, FormatParams outputFormatParams, Schema outputSchema, WarningsContext warningsContext, SerializedDataset.ReadWriteOptions readWriteOptions) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.provider = provider;
        this.datasetBase = datasetBase;
        this.partition = targetPartition;
        this.scheme = scheme;
        this.splitId = splitId;
        this.resplitFactor = resplitFactor == 0 ? 1 : resplitFactor;
        this.outputFormatType = outputFormatType;
        this.outputFormatParams = outputFormatParams;
        this.outputSchema = outputSchema;
        this.warningsContext = warningsContext;
        this.readWriteOptions = readWriteOptions;
    }

    public OutputWriter getWriter(Output.WriteMode writeMode) throws IOException {
        String outputDir;
        if (this.partition != null) {
            String partitionPath = FilePartitioner.computePartitionRelPathAsFolder(this.partition, this.scheme);
            outputDir = PathUtils.concatLNT((String[])new String[]{this.datasetBase, partitionPath});
        } else {
            outputDir = this.datasetBase;
        }
        String compress = null;
        if (this.outputFormatParams instanceof CompressibleFormatParams) {
            compress = ((CompressibleFormatParams)this.outputFormatParams).compress;
        }
        return new ResplittableExtensibleFileOutputWriter<HDFSProvider>(this.authCtx, this.projectKey, this.provider, outputDir, this.splitId, this.resplitFactor, this.outputFormatType, this.outputFormatParams, this.outputSchema, this.warningsContext, writeMode, compress, this.readWriteOptions);
    }

    public List<String> list(OutputWriter writer) {
        return ((ResplittableExtensibleFileOutputWriter)writer).gatherWritesInProgress();
    }

    public List<String> recoverList() throws IOException, CodedException, DKUSecurityException {
        return ResplittableExtensibleFileOutputWriter.gatherPathsWrittenToAndNotCommitted(this.provider, this.splitId);
    }
}

