/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pig;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.custom.CustomPythonFormatMeta;
import com.dataiku.dip.pig.DatasetRelationMapping;
import com.dataiku.dip.util.SafeColumnNamer;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.hproxy.model.pig.FieldDescription;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PigSchemaTools {
    private static final Pattern fieldCleaner = Pattern.compile("^(?:.*\\.)?([a-z0-9A-Z_]+?)$");
    private static Pattern pigLatinNamePattern = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$");

    public static SchemaColumn convertTypeFromPig(FieldDescription fd) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(fd.name);
        switch (fd.type) {
            case "bag": {
                sc = PigSchemaTools.convertBagFromPig(fd);
                break;
            }
            case "tuple": {
                sc = PigSchemaTools.convertTupleFromPig(fd);
                break;
            }
            case "map": {
                sc = PigSchemaTools.convertMapFromPig(fd);
                break;
            }
            case "bag-of-tuples": {
                sc = PigSchemaTools.convertBagOfTuples(fd);
                break;
            }
            case "int": {
                sc.setType(Type.INT);
                break;
            }
            case "long": 
            case "biginteger": {
                sc.setType(Type.BIGINT);
                break;
            }
            case "float": {
                sc.setType(Type.FLOAT);
                break;
            }
            case "bigdecimal": 
            case "double": {
                sc.setType(Type.DOUBLE);
                break;
            }
            case "boolean": {
                sc.setType(Type.BOOLEAN);
                break;
            }
            default: {
                sc.setType(Type.STRING);
            }
        }
        return sc;
    }

    private static SchemaColumn convertBagOfTuples(FieldDescription fd) {
        SchemaColumn bag = new SchemaColumn();
        bag.setType(Type.ARRAY);
        bag.setName(fd.name);
        bag.arrayContent = PigSchemaTools.convertTupleFromPig(fd);
        return bag;
    }

    private static SchemaColumn convertMapFromPig(FieldDescription fd) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(fd.name);
        sc.setType(Type.MAP);
        sc.mapKeys = new SchemaColumn();
        sc.mapKeys.setName("key");
        sc.mapKeys.setType(Type.STRING);
        if (fd.fields != null && fd.fields.size() == 1) {
            sc.mapValues = PigSchemaTools.convertTypeFromPig((FieldDescription)fd.fields.get(0));
        } else {
            sc.mapValues = new SchemaColumn();
            sc.mapValues.setType(Type.STRING);
            sc.mapValues.setName("key");
        }
        return sc;
    }

    private static SchemaColumn convertTupleFromPig(FieldDescription fd) {
        SchemaColumn sc = new SchemaColumn();
        sc.setName(fd.name);
        sc.setType(Type.OBJECT);
        sc.objectFields = new ArrayList();
        for (FieldDescription ofd : fd.fields) {
            sc.objectFields.add(PigSchemaTools.convertTypeFromPig(ofd));
        }
        return sc;
    }

    private static SchemaColumn convertBagFromPig(FieldDescription fd) {
        if (fd.fields.size() != 1 || !((FieldDescription)fd.fields.get((int)0)).type.equals("tuple")) {
            throw new NotImplementedException("Unsupported bag type from Pig (only bag-of-tuples are supported");
        }
        SchemaColumn sc = new SchemaColumn();
        sc.setName(fd.name);
        sc.setType(Type.ARRAY);
        sc.arrayContent = PigSchemaTools.convertTupleFromPig((FieldDescription)fd.fields.get(0));
        return sc;
    }

    private static String toPigTupleType(SchemaColumn type) {
        ArrayList<String> pigFields = new ArrayList<String>();
        for (SchemaColumn dkuField : type.objectFields) {
            pigFields.add(PigSchemaTools.toPigType(dkuField, true));
        }
        return "tuple(" + StringUtils.join(pigFields, (String)",") + ")";
    }

    private static String toPigMapType(SchemaColumn sc) {
        if (sc.mapKeys.getType() != Type.STRING) {
            throw new NotImplementedException("Pig doesn't support non-string map keys (column " + sc.getName() + ")");
        }
        return "map[" + PigSchemaTools.toPigType(sc.mapValues, false) + "]";
    }

    private static String toPigArrayType(SchemaColumn sc) {
        if (sc.arrayContent.getType() != Type.OBJECT) {
            throw new NotImplementedException("The type array<" + sc.arrayContent.getType().toString().toLowerCase() + "> cannot be used in a Pig recipe. Only array<object> is supported, because Pig only supports bag of tuples. (in column " + sc.getName() + ").");
        }
        return "bag{" + PigSchemaTools.toPigTupleType(sc.arrayContent) + "}";
    }

    public static String checkPigIdentifier(String name) {
        if (pigLatinNamePattern.matcher(name).matches()) {
            return name;
        }
        throw new NotImplementedException("Invalid identifier : \"" + name + "\". Pig identifiers start with a letter and can be followed by any number of letters, digits, or underscores.");
    }

    public static void checkPigSchemaCompatibility(Dataset dataset) {
        try {
            Schema schema = dataset.getSchema();
            if (schema == null) {
                throw new RuntimeException("Invalid null schema");
            }
            for (SchemaColumn sc : schema.getColumns()) {
                PigSchemaTools.toPigType(sc, false);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error in dataset " + dataset.getFullName() + ": " + e.getMessage(), e);
        }
    }

    public static String toPigType(SchemaColumn sc, boolean prependName) {
        switch (sc.getType()) {
            case TINYINT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "int";
            }
            case SMALLINT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "int";
            }
            case INT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "int";
            }
            case BIGINT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "long";
            }
            case FLOAT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "float";
            }
            case DOUBLE: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "double";
            }
            case BOOLEAN: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "boolean";
            }
            case STRING: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "chararray";
            }
            case DATE: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + "chararray";
            }
            case ARRAY: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + PigSchemaTools.toPigArrayType(sc);
            }
            case MAP: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + PigSchemaTools.toPigMapType(sc);
            }
            case OBJECT: {
                return (String)(prependName ? PigSchemaTools.checkPigIdentifier(sc.getName()) + ":" : "") + PigSchemaTools.toPigTupleType(sc);
            }
        }
        throw new NotImplementedException("Unsupported type " + String.valueOf(sc.getType()) + " in Pig recipe (column " + sc.getName() + ")");
    }

    public static Schema generateSchema(FieldDescription rel) {
        Schema schema = new Schema();
        if (rel.fields == null) {
            return schema;
        }
        SafeColumnNamer namer = new SafeColumnNamer();
        for (FieldDescription col : rel.fields) {
            String cleanName = PigSchemaTools.cleanPigFieldName(col.name);
            namer.addUnsafe(cleanName);
        }
        List<String> safeNames = namer.getSafeNames();
        for (int i = 0; i < rel.fields.size(); ++i) {
            FieldDescription col = (FieldDescription)rel.fields.get(i);
            String colName = safeNames.get(i);
            SchemaColumn sc = PigSchemaTools.convertTypeFromPig(col);
            sc.setName(colName);
            schema.addColumn(sc);
        }
        return schema;
    }

    public static String cleanPigFieldName(String str) {
        if (StringUtils.isBlank((String)str)) {
            str = "";
        }
        return fieldCleaner.matcher(str).replaceFirst("$1");
    }

    public static List<Suggestion> generateSuggestions(DatasetsDAO dao, Map<String, FlowComputable> targetableDatasets, List<FieldDescription> pigSchema, List<DatasetRelationMapping> dkuStoreMap) throws IOException, PigSchemaCoercionException {
        ArrayList<Suggestion> suggests = new ArrayList<Suggestion>();
        if (pigSchema == null) {
            return suggests;
        }
        for (DatasetRelationMapping mapping : dkuStoreMap) {
            FlowDataset flowDataset = (FlowDataset)targetableDatasets.get(mapping.dataset);
            if (flowDataset == null) {
                throw new RuntimeException("Unable to find dataset '" + mapping.dataset + "'");
            }
            Dataset dataset = flowDataset.getMandatory(dao);
            FieldDescription relation = null;
            for (FieldDescription field : pigSchema) {
                if (!field.name.equals(mapping.relation)) continue;
                relation = field;
            }
            if (relation == null) {
                throw new PigSchemaCoercionException("Unable to find the relation '" + mapping.relation + "' (stored into the dataset '" + mapping.dataset + "')");
            }
            if (relation.fields == null) {
                throw new PigSchemaCoercionException("Relation " + mapping.relation + " does not have a schema, cannot DKUSTORE it");
            }
            List<String> incompatibilityMsgs = SchemaComparator.findIncompatibilities(dataset.getSchema(), PigSchemaTools.generateSchema(relation), true);
            if (incompatibilityMsgs.size() <= 0) continue;
            Dataset datasetCopy = Dataset.fromSerialized(dataset.serialize());
            datasetCopy.setSchema(PigSchemaTools.generateSchema(relation));
            Suggestion suggestion = new Suggestion();
            suggestion.reasons = incompatibilityMsgs;
            suggestion.dataset = datasetCopy.serialize();
            suggests.add(suggestion);
        }
        return suggests;
    }

    public static PigCompatibilityStatus isFormatCompatible(Dataset dataset) {
        if (!DatasetInspector.canHDFS(dataset)) {
            return PigCompatibilityStatus.no("Dataset is not compatible with HDFS");
        }
        if (dataset.getFormatType() == null) {
            return PigCompatibilityStatus.no("Dataset has no format");
        }
        FormatMeta<?, ?> formatMeta = FormatFactory.getMeta(dataset.getFormatType());
        if (formatMeta instanceof CustomPythonFormatMeta) {
            return PigCompatibilityStatus.no("The format of this dataset cannot be read by Pig");
        }
        return PigCompatibilityStatus.yes();
    }

    public static class PigSchemaCoercionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        PigSchemaCoercionException(String message) {
            super(message);
        }
    }

    public static class Suggestion {
        public SerializedDataset dataset;
        public List<String> reasons;
    }

    public static class PigCompatibilityStatus {
        public boolean compatible;
        public String reason;

        static PigCompatibilityStatus no(String reason) {
            PigCompatibilityStatus ret = new PigCompatibilityStatus();
            ret.reason = reason;
            return ret;
        }

        static PigCompatibilityStatus yes() {
            PigCompatibilityStatus ret = new PigCompatibilityStatus();
            ret.compatible = true;
            return ret;
        }
    }
}

