/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.AbstractTimelineBinner;
import com.dataiku.dss.shadelib.org.joda.time.Chronology;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.chrono.GJChronology;

abstract class AbstractMonthBasedTimelineBinner
extends AbstractTimelineBinner {
    AbstractMonthBasedTimelineBinner() {
    }

    abstract int numberOfUnitInYear();

    abstract int numberOfElementInUnit();

    abstract String format(int var1, int var2);

    @Override
    public long getBinId(long timestamp) {
        DateTime dateTime = new DateTime(timestamp, (Chronology)GJChronology.getInstanceUTC());
        return (long)dateTime.getYear() * (long)this.numberOfUnitInYear() + (long)((dateTime.getMonthOfYear() - 1) / this.numberOfElementInUnit());
    }

    @Override
    public long getBinStartTimestamp(long binId) {
        return new DateTime(this.extractYear(binId), this.extractNumberOfUnit(binId) * this.numberOfElementInUnit() + 1, 1, 0, 0, 0, 0, (Chronology)GJChronology.getInstanceUTC()).getMillis();
    }

    @Override
    public String getLabel(long binId) {
        return this.format(this.extractYear(binId), this.extractNumberOfUnit(binId) + 1);
    }

    private int extractYear(long binId) {
        return (int)(binId / (long)this.numberOfUnitInYear());
    }

    private int extractNumberOfUnit(long binId) {
        return (int)(binId % (long)this.numberOfUnitInYear());
    }
}

