/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QuerySQLWriter;
import com.dataiku.dip.sql.queries.QueryUtils;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;

public class QueryUtils {
    private static final String chars = "azertyuiopqsdfghjklmwxcvbn0123456789";
    private static final Random rd = new Random();

    public static String inValues(SQLDialect dialect, String tested, List<String> vals, Function<String, String> transform, Type asType) {
        List<String> transformedVals;
        List<String> list = transformedVals = transform == null ? vals : vals.stream().map(transform::apply).collect(Collectors.toList());
        List<QueryAst.Expr> valsExprs = asType == Type.STRING ? transformedVals.stream().map(dialect::quoteString).map(QueryAst.InlineExpr::new).collect(Collectors.toList()) : transformedVals.stream().map(v -> new QueryAst.OperatorExpr(QueryUtils.OperatorType.CAST, new QueryAst.InlineExpr((String)v), new QueryAst.ConstExpr(asType))).collect(Collectors.toList());
        QueryAst.OperatorExpr inExpr = new QueryAst.OperatorExpr(QueryUtils.OperatorType.IN, new QueryAst.InlineExpr(tested), new QueryAst.ListExpr(valsExprs));
        return new QuerySQLWriter(dialect).toSQL(inExpr);
    }

    public static String safeRandomIdentifier(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        for (int i = 0; i < 10; ++i) {
            sb.append(chars.charAt(rd.nextInt(chars.length())));
        }
        return sb.toString();
    }
}

