/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.utils.DKULogger;

public class ProjectStandardsTemporaryProject
implements AutoCloseable {
    public final DSSAuthCtx owner;
    public final String projectKey;
    public boolean projectCreated = false;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projectStandards.temporaryProject");

    public ProjectStandardsTemporaryProject(DSSAuthCtx owner, String projectKey) {
        this.owner = owner;
        this.projectKey = projectKey;
    }

    @Override
    public void close() throws Exception {
        if (this.projectCreated) {
            try {
                logger.infoV("Deleting temporary project %s", new Object[]{this.projectKey});
                ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).projectDeletionAttempt(this.owner, this.projectKey, true, true, true);
            }
            catch (Exception e) {
                logger.warnV((Throwable)e, "Failed to delete temporary project %s", new Object[]{this.projectKey});
            }
        }
    }
}

