/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.impala;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.fs.HDFSDatasetHandler;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.impala.ImpalaQueryRecipeTester;
import com.dataiku.dip.recipes.code.impala.ImpalaRecipeExecutionUtils;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryInternalRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class ImpalaQueryInternalRunner
extends AbstractSQLQueryInternalRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sql");

    public ImpalaQueryInternalRunner(JobActivity activity, boolean overwriteTargetSchema) {
        super(activity, overwriteTargetSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DatasetLocUtils.DatasetLoc outputDatasetLoc, String initialQuery, List<String> preQueries, List<String> postQueries, boolean forceStreamMode) throws Exception {
        QueryBunch queryBunch = new QueryBunch();
        queryBunch.query = initialQuery;
        queryBunch.preQueries = preQueries;
        queryBunch.postQueries = postQueries;
        this.mainConnection = "mainconnectiondoesnotmatterforimpala";
        Dataset outputDataset = this.datasetAccessService.getMandatory(outputDatasetLoc);
        queryBunch.query = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), outputDataset.getProjectKey(), this.subgraph, queryBunch.query, new ImpalaSQLDialect(), false);
        queryBunch.query = this.stripEndSemicolon(queryBunch.query);
        queryBunch.optionalPreQueries = queryBunch.optionalPreQueries.stream().map(this::stripEndSemicolon).collect(Collectors.toList());
        queryBunch.preQueries = queryBunch.preQueries.stream().map(this::stripEndSemicolon).collect(Collectors.toList());
        queryBunch.postQueries = queryBunch.postQueries.stream().map(this::stripEndSemicolon).collect(Collectors.toList());
        try {
            Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
            if (!forceStreamMode && HiveQLQueryRecipeUtils.runsInSQLMode(this.authCtxService.getAuthCtx(), this.mainConnection, outputDataset, queryBunch.query) == null) {
                logger.info((Object)"Running the Impala query fragment in full-SQL mode");
                String outputImpalaDb = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(outputDataset).getSchemaNullIfBlank();
                ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(this.authCtxService.getAuthCtx(), outputImpalaDb);
                SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipeProjectKey);
                this.runFullSQLWithOW(outputDataset, targetPartition, connData, queryBunch);
            } else {
                FlowDataset firstSource = this.subgraph.getSourceDatasets().get(0);
                Dataset firstSourceDataset = firstSource.getMandatory(this.datasetsDAO);
                String outputImpalaDb = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(firstSourceDataset).getSchemaNullIfBlank();
                ImpalaConnection connection = ImpalaConfigurator.configureConnectionForDatabase(this.authCtxService.getAuthCtx(), outputImpalaDb);
                SQLConnectionProvider.SQLConnectionData connData = connection.getConnectionData_NT(this.authCtxService.getAuthCtx(), this.recipeProjectKey);
                this.runRegularToDatasetWithOW(this.authCtxService.getAuthCtx(), outputDataset, targetPartition, connData, queryBunch);
            }
        }
        finally {
            ImpalaQueryInternalRunner impalaQueryInternalRunner = this;
            synchronized (impalaQueryInternalRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    private String stripEndSemicolon(String sqlQuery) {
        if (sqlQuery.trim().endsWith(";")) {
            return sqlQuery.substring(0, sqlQuery.lastIndexOf(59));
        }
        return sqlQuery;
    }

    private void runFullSQLWithOW(Dataset outputDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData, QueryBunch queryBunch) throws Exception {
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(connData, this.authCtxService.getAuthCtx(), this.recipeProjectKey);){
            if (this.overwriteTargetSchema) {
                this.handleSchemaOverwrite(outputDataset, connData, conn, queryBunch, true);
            }
            try (HiveMetastoreSynchronizer sync = HiveMetastoreSynchronizerFactory.getSynchronizer(this.authCtxService.getAuthCtx());){
                try (HDFSDatasetHandler handler = (HDFSDatasetHandler)DatasetHandlerFactory.build(this.authCtxService.getAuthCtx(), outputDataset);){
                    handler.clearPartitions(Lists.newArrayList((Object[])new Partition[]{targetPartition}));
                }
                if (outputDataset.getPartitioningSchema().isPartitioned()) {
                    sync.dropPartitionIfExistsNoFail(outputDataset, targetPartition);
                } else {
                    sync.dropTableIfExists(outputDataset);
                }
                sync.synchronizeOneDatasetPartition(outputDataset, targetPartition, false, HiveMetastoreSynchronizer.SynchronizeOneDatasetPartitionReason.PRESYNCHRONIZE_WRITE_BY_IMPALA_TARGET, this.activity.warnContext, false);
            }
            Object transformedQuery = HiveQLQueryRecipeUtils.insertOverwriteFragment(outputDataset, targetPartition, Output.WriteMode.APPEND, true) + "\n" + queryBunch.query;
            transformedQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), outputDataset.getProjectKey(), this.subgraph, (String)transformedQuery, connData.getDialect(), false);
            ImpalaRecipeExecutionUtils.executeStatementsChainInImpala(conn, outputDataset, (String)transformedQuery, queryBunch.optionalPreQueries, queryBunch.preQueries, queryBunch.postQueries, this);
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed");
            throw e;
        }
    }

    @Override
    protected RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaResult(AuthCtx authCtx, Dataset targetDataset, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String sqlQuery) throws Exception {
        return ImpalaQueryRecipeTester.getSchemaResult_NT(authCtx, targetDataset, connData, conn, sqlQuery);
    }

    @Override
    public void run() throws Exception {
        throw new Error();
    }
}

