/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryInternalRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeTester;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.sql.SQLQueryToInsertTransformer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryInternalRunner
extends AbstractSQLQueryInternalRunner {
    @Autowired
    private JobAuthCtxService authCtxService;
    private boolean dropOnPartitionedMismatch;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sql");

    public SQLQueryInternalRunner(JobActivity activity, boolean overwriteTargetSchema, boolean dropOnPartitionedMismatch) {
        super(activity, overwriteTargetSchema);
        this.dropOnPartitionedMismatch = dropOnPartitionedMismatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DatasetLocUtils.DatasetLoc outputDatasetLoc, QueryBunch unexpandedQueryBunch) throws Exception {
        Dataset outputDataset = this.datasetAccessService.getMandatory(outputDatasetLoc);
        SQLQueryRecipeUtils.SQLConnections sourceConnections = SQLQueryRecipeUtils.getSourceConnections(this.authCtxService.getAuthCtx(), this.subgraph, this.datasetsDAO);
        if (sourceConnections.connections.size() > 1) {
            throw ErrorContext.iaef((String)"The SQL recipe is running across connections (%s)", (Object)Joiner.on((String)", ").join(sourceConnections.connections), (Object[])new Object[0]);
        }
        this.mainConnection = sourceConnections.firstConnection;
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(this.authCtxService.getAuthCtx(), outputDataset.getProjectKey(), this.mainConnection);
        try {
            Partition targetPartition = this.subgraph.getTargetPartition(this.subgraph.getTargets().get(0));
            if (SQLQueryRecipeUtils.runsInSQLMode(this.mainConnection, outputDataset, unexpandedQueryBunch.query)) {
                logger.info((Object)"Running the SQL query fragment in full-SQL mode");
                AbstractSQLDatasetHandler.AbstractSQLConfig outputConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)outputDataset.getParams();
                this.runFullSQLWithOW(outputConfig.catalog, outputConfig.schema, outputConfig.table, outputDataset, targetPartition, connData, unexpandedQueryBunch);
            } else {
                QueryBunch queryBunch = unexpandedQueryBunch.clone();
                AuthCtx authCtx = this.authCtxService.getAuthCtx();
                queryBunch.query = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, outputDataset.getProjectKey(), this.subgraph, queryBunch.query, connData.getDialect(), this.sqlQueryIsCommentFree);
                queryBunch.preQueries = queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, outputDataset.getProjectKey(), this.subgraph, q, connData.getDialect(), this.sqlQueryIsCommentFree)).collect(Collectors.toList());
                queryBunch.postQueries = queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, outputDataset.getProjectKey(), this.subgraph, q, connData.getDialect(), this.sqlQueryIsCommentFree)).collect(Collectors.toList());
                this.runRegularToDatasetWithOW(this.authCtxService.getAuthCtx(), outputDataset, targetPartition, connData, queryBunch);
            }
        }
        finally {
            SQLQueryInternalRunner sQLQueryInternalRunner = this;
            synchronized (sQLQueryInternalRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
    }

    private void runFullSQLWithOW(String outputCatalog, String outputSchema, String outputTable, Dataset outputDataset, Partition targetPartition, SQLConnectionProvider.SQLConnectionData connData, QueryBunch unexpandedQueryBunch) throws Exception {
        ConnectionTasksService.SQLQueryRun runningSQL = this.activity.runningThings.addSQL(this.mainConnection);
        Output.WriteMode wm = Output.WriteMode.OVERWRITE;
        RunnableSubgraph subGraph = this.activity.getSubgraph();
        if (subGraph instanceof RecipeRunnableSubgraph) {
            FlowRecipe recipe = ((RecipeRunnableSubgraph)subGraph).getRecipe();
            boolean isOutputDatasetInRecipeOutputs = false;
            List<SerializedRecipe.RecipeOutput> outputs = recipe.getModel().getFlatOutputs();
            for (SerializedRecipe.RecipeOutput output : outputs) {
                if (!output.getLoc(this.recipeProjectKey).equals(outputDataset.getLoc())) continue;
                wm = output.getWriteMode();
                isOutputDatasetInRecipeOutputs = true;
                break;
            }
            if (!isOutputDatasetInRecipeOutputs) {
                outputs = recipe.getModel().getOutputsForRole("main");
                if (outputs.isEmpty()) {
                    outputs = recipe.getModel().getFlatOutputs();
                }
                if (!outputs.isEmpty()) {
                    wm = outputs.get(0).getWriteMode();
                }
            }
        }
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(this.mainConnection, this.authCtxService.getAuthCtx(), this.recipeProjectKey);){
            Statement stmt;
            if (this.overwriteTargetSchema) {
                this.handleSchemaOverwrite(outputDataset, connData, conn, unexpandedQueryBunch, true);
            }
            AuthCtx authCtx = this.authCtxService.getAuthCtx();
            InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
            connData.getDialect().dropIfNeededAndCreateTableOrPartition(this.authCtxService.getAuthCtx(), connData, conn, outputDataset, targetPartition, wm, this.dropOnPartitionedMismatch, messages);
            if (!messages.isEmpty()) {
                this.activity.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
            }
            this.executePreWriteStatements(connData, conn, outputDataset);
            QueryBunch queryBunch = unexpandedQueryBunch.clone();
            String insertQuery = SQLQueryToInsertTransformer.transform(connData, queryBunch.query, outputCatalog, outputSchema, outputTable, outputDataset, this.sqlQueryMayContainUnionOrSelect);
            insertQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtxService.getAuthCtx(), outputDataset.getProjectKey(), this.subgraph, insertQuery, connData.getDialect(), this.sqlQueryIsCommentFree);
            queryBunch.preQueries = queryBunch.preQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, outputDataset.getProjectKey(), this.subgraph, q, connData.getDialect(), this.sqlQueryIsCommentFree)).collect(Collectors.toList());
            queryBunch.postQueries = queryBunch.postQueries.stream().map(q -> SQLQueryRecipeUtils.substituteAllAndStripCommentsUnchecked(authCtx, outputDataset.getProjectKey(), this.subgraph, q, connData.getDialect(), this.sqlQueryIsCommentFree)).collect(Collectors.toList());
            for (String query : queryBunch.preQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            try (Statement stmt2 = conn.createStatement();){
                this.executeCancellableStatement(conn, stmt2, insertQuery);
            }
            for (String query : queryBunch.postQueries) {
                stmt = conn.createStatement();
                try {
                    this.executeCancellableStatement(conn, stmt, query);
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            this.executePostWriteStatements(connData, conn, outputDataset);
            if (connData.getDialect().supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            logger.error((Object)"Query failed");
            throw e;
        }
        finally {
            runningSQL.doneOn = System.currentTimeMillis();
        }
    }

    @Override
    protected RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaResult(AuthCtx authCtx, Dataset targetDataset, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn, String sqlQuery) throws Exception {
        return SQLQueryRecipeTester.getSchemaResult_NT(authCtx, targetDataset, connData, conn, sqlQuery);
    }

    @Override
    public void run() throws Exception {
        throw new Error();
    }
}

