/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.AbstractElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.plugins.exceptions.DuplicateComponentException;
import com.dataiku.dip.plugins.model.CustomCodeRecipeDesc;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CustomCodeRecipesService
extends AbstractElementService<CustomCodeRecipeDesc, LoadedCustomCodeRecipeDesc> {
    @Override
    public String getFolderName() {
        return "custom-recipes";
    }

    @Override
    public String getPrefix() {
        return "recipe";
    }

    @Override
    public Class<CustomCodeRecipeDesc> getDescClass() {
        return CustomCodeRecipeDesc.class;
    }

    @Override
    public Class<LoadedCustomCodeRecipeDesc> getLoadedDescClass() {
        return LoadedCustomCodeRecipeDesc.class;
    }

    @Override
    protected String getCodeExtension(LoadedCustomCodeRecipeDesc desc) {
        switch (desc.desc.kind) {
            case JAVA: {
                return ".j";
            }
            case PYTHON: {
                return ".py";
            }
            case R: {
                return ".R";
            }
            case PYSPARK: {
                return ".py";
            }
            case SPARK_SCALA: {
                return ".scala";
            }
        }
        throw new Error("unreachable");
    }

    @Override
    protected void removeElement(LoadedCustomCodeRecipeDesc desc) {
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "CustomCode_" + elementId;
    }

    @Override
    protected LoadedCustomCodeRecipeDesc load(String elementType, String pluginId, String elementId, File file) throws IOException, DuplicateComponentException {
        CustomCodeRecipeDesc codeRecipeDesc = (CustomCodeRecipeDesc)JSON.parseFileWithDetailsInExceptionRatherThanLogs((File)file, CustomCodeRecipeDesc.class);
        LoadedCustomCodeRecipeDesc loaded = new LoadedCustomCodeRecipeDesc(elementId, pluginId, elementType, codeRecipeDesc);
        for (RecipeDesc.IORoleDef role : loaded.desc.inputRoles) {
            role.editableInEditor = true;
            role.editableInModal = true;
        }
        for (RecipeDesc.IORoleDef role : loaded.desc.outputRoles) {
            role.editableInEditor = true;
            role.editableInModal = true;
        }
        CustomCodeRecipeMeta meta = new CustomCodeRecipeMeta(loaded);
        for (RecipeMeta recipeMeta : RecipeRegistry.getAllMeta()) {
            if (!recipeMeta.getType().equals(meta.getType())) continue;
            if (!(recipeMeta instanceof CustomCodeRecipeMeta)) {
                throw new IOException("The recipe type '" + meta.getType() + "' is already registered by a non-custom recipe.");
            }
            CustomCodeRecipeMeta customRecipeMeta = (CustomCodeRecipeMeta)recipeMeta;
            if (customRecipeMeta.getPluginDesc().ownerPluginId.equals(meta.getPluginDesc().ownerPluginId)) continue;
            throw new DuplicateComponentException("The recipe identifier '" + loaded.id + "' is already registered by another recipe in the plugin " + customRecipeMeta.getPluginDesc().ownerPluginId + ".");
        }
        RecipeRegistry.register(meta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final CustomCodeRecipeDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.kind == null) {
                    this.withFatal("Plugin recipes require a \"kind\" field (PYTHON, R, PYSPARK, SPARK_SCALA, JAVA).");
                } else if (desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.SPARK_SCALA && desc.codeMode == null) {
                    this.withFatal("Spark scala plugin recipes require a \"codeMode\" field (FREE_FORM or FUNCTION).");
                } else if (desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.JAVA && StringUtils.isBlank((String)desc.recipeClass)) {
                    this.withFatal("Java plugin recipes require a \"recipeClass\" field.");
                }
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, CustomCodeRecipesService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                if (desc.meta != null) {
                    if (StringUtils.isBlank((String)desc.meta.description)) {
                        this.withWarning("It is advised to add a description to recipes");
                    }
                    if (desc.meta.label != null && desc.meta.label.toLowerCase().contains("recipe")) {
                        this.withWarning("It is not advised to include \"recipe\" in a recipe label.");
                    }
                }
                if (desc.outputRoles == null || desc.outputRoles.size() == 0) {
                    this.withFatal("Plugin recipes require outputRoles");
                } else {
                    for (RecipeDesc.IORoleDef r : desc.outputRoles) {
                        if (r != null) {
                            ArrayList<String> usedNames = new ArrayList<String>(desc.outputRoles.size());
                            if (StringUtils.isBlank((String)r.name)) {
                                this.withFatal("Plugin recipes output roles must have names");
                            } else if (usedNames.contains(r.name)) {
                                this.withFatal("Duplicate output roles name: " + r.name);
                            }
                            usedNames.add(r.name);
                            continue;
                        }
                        this.withWarning("Null output role in recipe, make sure there is no trailing comma");
                    }
                }
                HashMap<String, RecipeDesc.IORoleDef> inputRolesByName = new HashMap<String, RecipeDesc.IORoleDef>();
                if (desc.inputRoles != null) {
                    for (RecipeDesc.IORoleDef r : desc.inputRoles) {
                        if (r != null) {
                            if (StringUtils.isBlank((String)r.name)) {
                                this.withFatal("Plugin recipes input roles must have names");
                                continue;
                            }
                            if (inputRolesByName.containsKey(r.name)) {
                                this.withFatal("Duplicate input roles name: " + r.name);
                                continue;
                            }
                            inputRolesByName.put(r.name, r);
                            continue;
                        }
                        this.withWarning("Null input role in recipe, make sure there is no trailing comma");
                    }
                }
                if (desc.params != null) {
                    for (ParamDesc p : desc.params) {
                        if (p == null || p.type != ParamDesc.Type.COLUMN && p.type != ParamDesc.Type.COLUMNS) continue;
                        if (StringUtils.isBlank((String)p.columnRole)) {
                            this.withFatal("No columnRole specified for COLUMN param: " + p.name);
                            continue;
                        }
                        if (inputRolesByName.containsKey(p.columnRole)) continue;
                        this.withFatal("columnRole specified for COLUMN param '" + p.name + "' does not exist: " + p.columnRole);
                    }
                }
                this.addWarningInputRoleDoesntExist(inputRolesByName, desc.selectableFromDataset, "selectableFromDataset");
                this.addWarningInputRoleDoesntExist(inputRolesByName, desc.selectableFromFolder, "selectableFromFolder");
                this.addWarningInputRoleDoesntExist(inputRolesByName, desc.selectableFromSavedModel, "selectableFromSavedModel");
                return this.messages;
            }

            private void addWarningInputRoleDoesntExist(Map<String, RecipeDesc.IORoleDef> inputRolesByName, String inputName, String selectType) {
                if (inputName != null && !inputRolesByName.containsKey(inputName)) {
                    this.withWarning("inputRole specified in " + selectType + " doesn't exist: " + inputName);
                }
            }
        }.validate();
    }

    public String getLibFolder(String recipeType) {
        if (!this.loadedDescs.containsKey(recipeType)) {
            throw new IllegalArgumentException("Recipe " + recipeType + " is not loaded.");
        }
        LoadedCustomCodeRecipeDesc rd = (LoadedCustomCodeRecipeDesc)this.loadedDescs.get(recipeType);
        if (rd.desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.PYTHON || rd.desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.PYSPARK) {
            File libDir = this.pluginsService.getPluginPythonlibFolder(rd.ownerPluginId);
            return libDir.getAbsolutePath();
        }
        if (rd.desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.SPARK_SCALA || rd.desc.kind == CustomCodeRecipeDesc.CustomRecipeLanguage.JAVA) {
            return this.pluginsService.getPluginJavalibFolder(rd.ownerPluginId).getAbsolutePath();
        }
        return null;
    }
}

