/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.nlp.embed_documents;

import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedData;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.ExtractedDataWriter;
import com.dataiku.dip.recipes.nlp.common.doc_extraction.chunks.SingleExtractedChunk;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Set;

public class ExtractedDataJsonLFileWriter
extends ExtractedDataWriter {
    static final String KNOWLEDGE_PROPERTY_NAME = "DKU_GENERATED_EMBEDDING";
    static final String SECURITY_TOKEN_NAME = "DKU_SECURITY_TOKENS";
    static final String MULTIMODAL_PROPERTY_NAME = "DKU_MULTIMODAL_CONTENT";
    static final String METADATA_PROPERTY_NAME = "DKU_DOCUMENT_INFO";
    File toAddChunksContentFile;
    File toAddChunksUuidsFile;
    File toRemoveChunksUuidsFile;

    public ExtractedDataJsonLFileWriter(AutoDelete outputDir) throws IOException {
        this.toAddChunksContentFile = new File((File)outputDir, "to_add_chunks_content.jsonl");
        this.toAddChunksUuidsFile = new File((File)outputDir, "to_add_chunks_uuids.csv");
        this.toRemoveChunksUuidsFile = new File((File)outputDir, "to_delete_chunks_uuids.csv");
        FileUtils.write((File)this.toAddChunksContentFile, (CharSequence)"", (String)"utf8", (boolean)true);
        FileUtils.write((File)this.toAddChunksUuidsFile, (CharSequence)"", (String)"utf8", (boolean)true);
        FileUtils.write((File)this.toRemoveChunksUuidsFile, (CharSequence)"", (String)"utf8", (boolean)true);
    }

    @Override
    protected synchronized void writeAppend(InputRefs.ManagedFolderDocumentRefWithMetadata document, ExtractedData extractedData) throws IOException {
        try (BufferedWriter bwChunks = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.toAddChunksContentFile, true), StandardCharsets.UTF_8));
             BufferedWriter bwUuids = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.toAddChunksUuidsFile, true), StandardCharsets.UTF_8));){
            extractedData.chunks.forEach(chunk -> {
                try {
                    bwChunks.write(this.jsonifyChunk((SingleExtractedChunk)chunk, document.securityToken, document.userMetadata).toString());
                    bwChunks.newLine();
                    bwUuids.write(chunk.uuid);
                    bwUuids.newLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    JsonObject jsonifyChunk(SingleExtractedChunk chunk, String securityToken, HashMap<String, String> userMetadata) {
        JsonObject jsonifiedChunk = new JsonObject();
        jsonifiedChunk.addProperty(KNOWLEDGE_PROPERTY_NAME, chunk.embedValue);
        jsonifiedChunk.addProperty(MULTIMODAL_PROPERTY_NAME, JSON.json((Object)chunk.multimodalPart));
        userMetadata.forEach((arg_0, arg_1) -> ((JsonObject)jsonifiedChunk).addProperty(arg_0, arg_1));
        jsonifiedChunk.addProperty(METADATA_PROPERTY_NAME, JSON.json((Object)chunk.extractedMetadata));
        if (chunk.extractedMetadata.sourceFile != null) {
            jsonifiedChunk.addProperty("dku_file_path", chunk.extractedMetadata.sourceFile.path);
        }
        if (securityToken != null) {
            jsonifiedChunk.addProperty(SECURITY_TOKEN_NAME, securityToken);
        }
        return jsonifiedChunk;
    }

    @Override
    public void dumpOutdatedChunksUuids(Set<String> chunksIdsToDelete) throws IOException {
        FileUtils.writeLines((File)this.toRemoveChunksUuidsFile, (String)"utf8", chunksIdsToDelete, (String)"\n", (boolean)false);
    }

    @Override
    public String buildMessageLogForDocument(InputRefs.ManagedFolderDocumentRef documentRef, String message) {
        return String.format("[%s] - %s", documentRef.filePath, message);
    }
}

