/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RemoteRunFileExchangeClient {
    private final String executionId;
    private final TicketBasedIntercomAPIClient intercomClient;
    private final String apiPath;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.remoterun.fileexchange.client");

    public RemoteRunFileExchangeClient(TicketBasedIntercomAPIClient intercomClient, String apiPath, String executionId) {
        this.intercomClient = intercomClient;
        this.apiPath = apiPath;
        this.executionId = executionId;
    }

    public void downloadSingleFile(RemoteRunFileExchangeService.FileKind fileKind, String targetPath, File targetFolder) throws IOException {
        HttpEntity entity = this.intercomClient.postFormToStream(this.apiPath + "/containers/get-file", new Object[]{"executionId", this.executionId, "fileKind", fileKind.toString(), "path", targetPath});
        logger.info((Object)("Downloading file " + targetPath + " To " + String.valueOf(targetFolder)));
        try (FileOutputStream os = new FileOutputStream(new File(targetFolder, new File(targetPath).getName()));){
            IOUtils.copy((InputStream)entity.getContent(), (OutputStream)os);
        }
    }

    public void zipAndUpload(File folder, String targetFileName, RemoteRunFileExchangeService.FileKind fileKind, String targetPath) throws IOException {
        try (AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"rrfe-zip", (String)"file", (String)"zip");){
            ZipUnzipDir.zipDirectory(folder, (File)tmpFile);
            this.intercomClient.postFormAndFileToJSON(this.apiPath + "/containers/put-file-multipart", JsonObject.class, (File)tmpFile, targetFileName, new Object[]{"executionId", this.executionId, "fileKind", fileKind.toString(), "path", targetPath});
        }
    }

    public void uploadSingleFile(File file, RemoteRunFileExchangeService.FileKind fileKind, String targetPath) throws IOException {
        this.intercomClient.postFormAndFileToJSON(this.apiPath + "/containers/put-file-multipart", JsonObject.class, file, file.getName(), new Object[]{"executionId", this.executionId, "fileKind", fileKind.toString(), "path", targetPath});
    }

    public void uploadSingleFile(InputStream inputStream, String fileName, RemoteRunFileExchangeService.FileKind fileKind, String targetPath) throws IOException {
        this.intercomClient.postFormAndFileToJSON(this.apiPath + "/containers/put-file-multipart", JsonObject.class, inputStream, fileName, new Object[]{"executionId", this.executionId, "fileKind", fileKind.toString(), "path", targetPath});
    }
}

