/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.remoterun.IntercomClientBuilder;
import com.dataiku.dip.remoterun.RemoteRunEnvDef;
import com.dataiku.dip.remoterun.RemoteRunEnvHelper;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeClient;
import com.dataiku.dip.remoterun.RemoteRunFileExchangeService;
import com.dataiku.dip.remoterun.RemoteRunLocalFilesHelper;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class RemoteRunFileExchangeHelper {
    private static Logger logger = Logger.getLogger((String)"dku.remoterun.fileexchange.helper");

    public static void storeZippedFolder2(String baseName, File folder, String targetPath) throws IOException {
        block9: {
            DKUFileUtils.checkNoPossibleEscape((String)baseName, (String)"Spark write-out");
            RemoteRunEnvDef env = RemoteRunEnvHelper.getEnvDef();
            if (env.runsRemotely) {
                try (TicketBasedIntercomAPIClient apiClient = IntercomClientBuilder.build();){
                    RemoteRunFileExchangeClient rrfec = new RemoteRunFileExchangeClient(apiClient, IntercomClientBuilder.getIntercomAPIPath(), RemoteRunEnvHelper.getEnvDef().jobId);
                    rrfec.zipAndUpload(folder, baseName, RemoteRunFileExchangeService.FileKind.FILTERED_PATHS, targetPath);
                    break block9;
                }
                catch (Throwable e) {
                    logger.error((Object)("Failure to send folder " + folder.getName() + " as " + targetPath), e);
                    throw e;
                }
            }
            logger.info((Object)("Running locally, need to storeZippedFolder " + String.valueOf(folder)));
        }
    }

    public static void storeFile(File file, String targetPath) throws IOException {
        block9: {
            RemoteRunEnvDef env = RemoteRunEnvHelper.getEnvDef();
            if (env.runsRemotely) {
                try (TicketBasedIntercomAPIClient apiClient = IntercomClientBuilder.build();){
                    RemoteRunFileExchangeClient rrfec = new RemoteRunFileExchangeClient(apiClient, IntercomClientBuilder.getIntercomAPIPath(), RemoteRunEnvHelper.getEnvDef().jobId);
                    rrfec.uploadSingleFile(file, RemoteRunFileExchangeService.FileKind.FILTERED_PATHS, targetPath);
                    break block9;
                }
                catch (Throwable e) {
                    logger.error((Object)("Failure to send file " + file.getName() + " as " + targetPath), e);
                    throw e;
                }
            }
            logger.info((Object)("Running locally, need to store " + String.valueOf(file)));
        }
    }

    public static void storeJsonOutput(String name, Object o) {
        DKUFileUtils.checkNoPossibleEscape((String)name, (String)"Spark write-out");
        RemoteRunEnvDef env = RemoteRunEnvHelper.getEnvDef();
        if (env.runsRemotely) {
            try (TicketBasedIntercomAPIClient apiClient = IntercomClientBuilder.build();
                 AutoDelete tmpFile = DSSTempUtils.getTempFile((String)"json-output", (String)"file", (String)"json");){
                JSON.prettyToFile((Object)o, (File)tmpFile);
                logger.info((Object)("Writing JSON output file " + name + " jobId= " + RemoteRunEnvHelper.getEnvDef().jobId));
                RemoteRunFileExchangeClient rrfec = new RemoteRunFileExchangeClient(apiClient, IntercomClientBuilder.getIntercomAPIPath(), RemoteRunEnvHelper.getEnvDef().jobId);
                rrfec.uploadSingleFile((File)tmpFile, RemoteRunFileExchangeService.FileKind.FILTERED_PATHS, name);
            }
            catch (Exception e) {
                logger.error((Object)("Failed to dump " + name), (Throwable)e);
            }
        } else {
            logger.info((Object)("Running locally, dump " + name + " into cwd"));
            try {
                JSON.prettyToFile((Object)o, (File)RemoteRunLocalFilesHelper.getRunFile(name));
            }
            catch (IOException e) {
                logger.error((Object)("Failed to dump " + name), (Throwable)e);
            }
        }
    }
}

