/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.savedmodels.proxymodelversions;

import com.dataiku.dip.apideployer.DeployerUtils;
import com.dataiku.dip.connections.DatabricksModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.databricks.DatabricksHTTPClient;
import com.dataiku.dip.externalinfras.databricks.DatabricksInputValidator;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServedModel;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointDetails;
import com.dataiku.dip.externalinfras.databricks.datamodel.DatabricksServingEndpointTrafficRoute;
import com.dataiku.dip.savedmodels.proxymodels.DatabricksProxyConfiguration;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DatabricksProxyModelVersionConfiguration
extends ProxyModelVersionConfiguration {
    public String endpointName;

    @Override
    public void validate() {
        super.validate();
        DatabricksInputValidator.validateEndpointName(this.endpointName);
    }

    @Override
    public ProxyModelVersionConfiguration.ConsolidatedEndpointInfo getConsolidatedEndpointInfo_NT(AuthCtx authCtx) throws IOException, DKUSecurityException, URISyntaxException {
        DatabricksProxyConfiguration proxyConfiguration = (DatabricksProxyConfiguration)this.proxyModelConfiguration;
        if (this.proxyModelConfiguration == null) {
            throw new IllegalArgumentException("Missing proxyModelConfiguration");
        }
        if (StringUtils.isEmpty((CharSequence)this.endpointName)) {
            logger.warn((Object)"Endpoint name should be defined");
            return null;
        }
        DatabricksModelDeploymentConnection connection = (DatabricksModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(authCtx, proxyConfiguration.connection);
        if (null == connection) {
            throw new IllegalArgumentException("Connection " + proxyConfiguration.connection + " not found or not a " + DatabricksModelDeploymentConnection.class.getSimpleName());
        }
        DatabricksHTTPClient client = connection.getClient(authCtx, DeployerUtils.getInfraConnectTimeout(), DeployerUtils.getInfraSocketTimeout());
        DatabricksServingEndpointDetails servingEndpointDetails = client.getServingEndpointDetails(this.endpointName);
        if (null == servingEndpointDetails || null == servingEndpointDetails.config) {
            return null;
        }
        return new DSSDatabricksConsolidatedEndpointInfo(servingEndpointDetails, connection);
    }

    public static class DSSDatabricksConsolidatedEndpointInfo
    extends ProxyModelVersionConfiguration.ConsolidatedEndpointInfo {
        public String id;
        public String host;
        public String endpointName;
        @Nonnull
        public List<DatabricksServedModel> servedModels = new ArrayList<DatabricksServedModel>();
        public Map<String, Long> trafficSplit = new HashMap<String, Long>();
        public long configVersion;

        DSSDatabricksConsolidatedEndpointInfo(DatabricksServingEndpointDetails details, DatabricksModelDeploymentConnection connection) {
            this.id = details.id;
            this.endpointName = details.name;
            this.host = connection.params.host;
            this.servedModels = details.config.servedModels;
            if (null != details.config.trafficConfig && null != details.config.trafficConfig.routes) {
                for (DatabricksServingEndpointTrafficRoute route : details.config.trafficConfig.routes) {
                    this.trafficSplit.put(route.servedModelName, route.trafficPercentage);
                }
            }
            this.configVersion = details.config.configVersion;
        }

        public DSSDatabricksConsolidatedEndpointInfo() {
        }

        @Override
        public InfoMessage.InfoMessages computeDifferences(@Nonnull ProxyModelVersionConfiguration.ConsolidatedEndpointInfo other) {
            String currentDep;
            String initialDep;
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (other.getClass() == ProxyModelVersionConfiguration.ErrorEndpointInfo.class) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Remote endpoint error", ((ProxyModelVersionConfiguration.ErrorEndpointInfo)other).errorMessage));
                return ret;
            }
            if (this.getClass() != other.getClass()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Wrong type", "Type mismatch between configuration and remote endpoint"));
                return ret;
            }
            DSSDatabricksConsolidatedEndpointInfo dbxOther = (DSSDatabricksConsolidatedEndpointInfo)other;
            if (this.configVersion != dbxOther.configVersion) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Configuration version differs", "The configuration of the endpoint changed since its creation"));
            }
            if (!(initialDep = this.servedModels.stream().map(s -> s.modelName).sorted().collect(Collectors.joining(", "))).equals(currentDep = dbxOther.servedModels.stream().map(s -> s.modelName).sorted().collect(Collectors.joining(", ")))) {
                String msg = String.format("At version creation: '%s'.%nCurrently on remote endpoint: '%s'.", initialDep, currentDep);
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Deployments differ", msg));
            } else if (!this.trafficSplit.equals(dbxOther.trafficSplit)) {
                String msg = String.format("At version creation: '%s'.%nCurrently on remote endpoint: '%s'.", this.trafficSplit.entrySet().stream().map(e -> (String)e.getKey() + " -> " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")), dbxOther.trafficSplit.entrySet().stream().map(e -> (String)e.getKey() + " -> " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")));
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Traffic configuration differs", msg));
            }
            if (ret.messages.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.INFO, "Information matches", "The endpoint has the same configuration as when this DSS saved model version was created"));
            }
            return ret;
        }
    }
}

