/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.triggers;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.UnavailablePluginItemInfo;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.triggers.DeletedPythonPluginTriggerMeta;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.scheduler.triggers.TriggerMeta;
import com.dataiku.dip.scheduler.triggers.TriggerRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Maps;
import java.util.Map;

public class TriggerRegistry {
    private static final Map<String, TriggerMeta> library = Maps.newLinkedHashMap();
    private static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.scheduler.triggers");

    public static TriggerRunner buildRunner(Scenario scenario, Trigger trigger) {
        TriggerRunner runner = TriggerRegistry.getMeta(trigger).buildRunner(scenario, trigger);
        SpringUtils.getInstance().autowire((Object)runner);
        return runner;
    }

    public static TriggerMeta getMeta(Trigger trigger) {
        try {
            return TriggerRegistry.getMeta(trigger.getType());
        }
        catch (CodedRuntimeException cre) {
            UnavailablePluginItemInfo info = new UnavailablePluginItemInfo(trigger.getType(), null);
            logger.errorV((Throwable)cre, "(triggerId: %s) Could not find trigger type %s", new Object[]{trigger.id, trigger.getType()});
            return new DeletedPythonPluginTriggerMeta(info.pluginId, info.elementId);
        }
    }

    public static synchronized TriggerMeta getMeta(String type) {
        if (library.containsKey(type)) {
            return library.get(type);
        }
        if (type.startsWith("pytrigger")) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_INSTALLED, "Unknown trigger type: " + type);
        }
        throw new IllegalStateException("Unknown trigger type " + type);
    }

    public static synchronized void register(TriggerMeta meta) {
        library.put(meta.getType(), meta);
    }

    public static synchronized void deregister(String triggerType) {
        library.remove(triggerType);
    }
}

