/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.impersonation;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLHandler;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.impersonation.UserImpersonationTarget;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.io.IOException;

public class FilesystemACLUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.utils.fsacl");

    public static void tryPrintFileACLs(File f) {
        try {
            DKUtils.execAndLogThrows((String[])new String[]{"getfacl", f.getAbsolutePath()}, null, (File)null);
        }
        catch (Throwable t) {
            logger.warn((Object)("Could not print ACLs for " + f.getAbsolutePath() + ": " + ExceptionUtils.getMessageWithCauses((Throwable)t)));
        }
    }

    public static void grantFSFullACLs(AuthCtx authCtx, String projectKey, File ... dirs) throws DKUSecurityException, IOException, InterruptedException {
        FilesystemACLUtils.grantFSFullACLs(authCtx, projectKey, true, dirs);
    }

    public static void grantFSFullACLs(AuthCtx authCtx, String projectKey, boolean recursive, File ... dirs) throws DKUSecurityException, IOException, InterruptedException {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            UserImpersonationTarget impersonationTarget = impersonationService.getTargetUser(projectKey, authCtx);
            logger.info((Object)("Impersonating: FS granting additional access to " + impersonationTarget.unixUser));
            FilesystemACLHandler handler = new FilesystemACLHandler();
            for (File f : dirs) {
                handler.grantAdditionalFullAccess(f, impersonationTarget.unixUser, recursive);
            }
        }
    }

    public static void grantFSReadACLs(AuthCtx authCtx, String projectKey, File ... dirs) throws DKUSecurityException, IOException, InterruptedException {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            UserImpersonationTarget impersonationTarget = impersonationService.getTargetUser(projectKey, authCtx);
            logger.info((Object)("Impersonating: FS granting additional READ access to " + impersonationTarget.unixUser));
            FilesystemACLHandler handler = new FilesystemACLHandler();
            for (File f : dirs) {
                handler.grantAdditionalReadRecursiveAccess(f, impersonationTarget.unixUser);
            }
        }
    }

    public static void removeACLRestrictiveMask(File dir) {
        ImpersonationResolverService impersonationService = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (impersonationService.isEnabled()) {
            try {
                FilesystemACLHandler handler = new FilesystemACLHandler();
                logger.info((Object)("Impersonating: Removing restrictive mask on folder " + String.valueOf(dir)));
                handler.setMaskRWX(dir);
            }
            catch (IOException | InterruptedException e) {
                logger.error((Object)("Failed to remove mask on folder " + String.valueOf(dir)), (Throwable)e);
            }
        }
    }

    public static void restrictRwxToDSSUnconditionally(File file) throws IOException, InterruptedException {
        FilesystemACLHandler aclHandler = new FilesystemACLHandler();
        aclHandler.chmod700(file);
        aclHandler.setMaskRWX(file);
    }

    public static void restrictRwxToDSSIfImpersonationEnabled(File file) throws IOException, InterruptedException {
        ImpersonationResolverService irs = (ImpersonationResolverService)SpringUtils.getBean(ImpersonationResolverService.class);
        if (irs.isEnabled()) {
            FilesystemACLUtils.restrictRwxToDSSUnconditionally(file);
        }
    }
}

