/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.analysis.ml.prediction.ModelDataUtilsService;
import com.dataiku.dip.expressions.ExpressionFixingService;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.pivot.backend.dss.aggregators.LinoColumnFactory;
import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SQLNotebooksDataService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.shaker.server.SerializedMemTableV2;
import com.dataiku.dip.shaker.server.SerializedTableChunk;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class SQLNotebooksDataController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private SQLNotebooksDataService sqlNotebooksDataService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private ExpressionFixingService expressionFixingService;
    @Autowired
    private ModelDataUtilsService modelDataUtilsService;

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/get-pivot-response"})
    public void getPivotResponse(HttpServletRequest req, HttpServletResponse resp, @RequestParam String request, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        PivotTableRequest pivotTableRequest = (PivotTableRequest)JSON.parse((String)request, PivotTableRequest.class);
        SQLNotebooksDataService.QueryFullIdentifier qfi = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, this.sqlNotebooksDataService.getPivotResponse_NT(user, pivotTableRequest, qfi));
    }

    @AuditInline
    @RequestMapping(value={"/api/sql-notebooks/get-columns-summary"})
    public void getColumnsSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLNotebooksDataService.QueryFullIdentifier qfi = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, (Object)this.sqlNotebooksDataService.getColumnSummary_NT(qfi));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/refresh-table"}, method={RequestMethod.POST})
    public void refreshTable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid, @RequestParam String displayScript, @RequestParam(value="filters", required=false, defaultValue="") String filters) throws Exception {
        AuthCtx user;
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLNotebooksDataService.QueryFullIdentifier queryIdentifier = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        RefreshTableFutureThread ft = new RefreshTableFutureThread((DSSAuthCtx)user, queryIdentifier, sss, (FilterRequest)JSON.parse((String)filters, FilterRequest.class));
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, this.futureService.runFuture(ft, 2000L, new TypeToken<FutureResponse<SerializedMemTableV2>>(){}));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/get-table-chunk"})
    public void getTableChunk(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid, @RequestParam String displayScript, @RequestParam int firstRow, @RequestParam int nbRows, @RequestParam int firstCol, @RequestParam int nbCols, @RequestParam String filters) throws Exception {
        SerializedShakerScript sss = (SerializedShakerScript)JSON.parse((String)displayScript, SerializedShakerScript.class);
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLNotebooksDataService.QueryFullIdentifier queryIdentifier = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        MemScriptRunner.TableWithReport twr = this.sqlNotebooksDataService.getTableWithReportForQueryResult(queryIdentifier, (FilterRequest)JSON.parse((String)filters, FilterRequest.class), sss);
        SerializedTableChunk res = new SerializedTableChunk(firstRow, nbRows, firstCol, nbCols);
        res.fill(twr.table, twr.filters, sss.coloring, sss.columnsSelection);
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, (Object)res);
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/detailed-column-analysis"})
    public void detailedColumnAnalysis(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid, @RequestParam String data, @RequestParam String column, @RequestParam int alphanumMaxResults) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SerializedShakerScript ss = (SerializedShakerScript)JSON.parse((String)data, SerializedShakerScript.class);
        SQLNotebooksDataService.QueryFullIdentifier qfi = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, (Object)this.sqlNotebooksDataService.getDetailedColumnAnalysis(qfi, ss, column, alphanumMaxResults));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/sql-notebooks/fix-expression"}, method={RequestMethod.POST})
    public void fixExpression(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String notebookId, @RequestParam String qid, @RequestParam String expression, @RequestParam String fixName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        SQLNotebooksDataService.QueryFullIdentifier qfi = new SQLNotebooksDataService.QueryFullIdentifier(projectKey, notebookId, qid);
        LinoColumnFactory columnsFactory = this.sqlNotebooksDataService.getColumnsFactory(qfi);
        String fixedExpression = this.expressionFixingService.fixExpression(expression, fixName, projectKey, columnsFactory);
        SQLNotebooksDataController.writeJSON((HttpServletResponse)resp, (Object)fixedExpression);
    }

    private class RefreshTableFutureThread
    extends FutureThread<SerializedMemTableV2> {
        private final SQLNotebooksDataService.QueryFullIdentifier qfi;
        private final SerializedShakerScript displayScript;
        private final FilterRequest filterRequest;
        private final FuturePayload futurePayload;
        SerializedMemTableV2 result;

        public RefreshTableFutureThread(DSSAuthCtx user, SQLNotebooksDataService.QueryFullIdentifier qfi, SerializedShakerScript sss, FilterRequest filterRequest) {
            super(user);
            this.result = null;
            this.qfi = qfi;
            this.displayScript = sss;
            this.filterRequest = filterRequest;
            this.futurePayload = this.buildFuturePayload(qfi);
        }

        private FuturePayload buildFuturePayload(SQLNotebooksDataService.QueryFullIdentifier queryIdentifier) {
            FuturePayload fp = new FuturePayload();
            fp.targets.add(DSSFuturePayloadUtils.forSQLNotebook(queryIdentifier.projectKey(), queryIdentifier.notebookId()).withPart("Sample"));
            fp.action = "refresh_query-result-set";
            fp.displayName = "Refreshing query result set";
            return this.futurePayload;
        }

        public SerializedMemTableV2 getResult() {
            return this.result;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public void execute() throws Exception {
            try {
                MemScriptRunner.TableWithReport twr = SQLNotebooksDataController.this.sqlNotebooksDataService.getTableWithReportForQueryResult(this.qfi, this.filterRequest, this.displayScript);
                SerializedMemTableV2 serializedMemTable = new SerializedMemTableV2();
                serializedMemTable.fill(twr, this.displayScript, 64, Integer.MAX_VALUE);
                this.result = serializedMemTable;
            }
            catch (Exception e) {
                DIPInternalControllerBase.logger.error((Object)"Failed to get table data", (Throwable)e);
                throw e;
            }
        }
    }
}

