/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.IllegalConfigurationException;
import com.dataiku.dip.integrations.IntegrationChannel;
import com.dataiku.dip.integrations.mail.AbstractMailSender;
import com.dataiku.dip.integrations.mail.factory.MailSenderFactory;
import com.dataiku.dip.scheduler.IntegrationChannelsDAO;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailNotificationsSender {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private IntegrationChannelsDAO integrationChannelsDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private MailSenderFactory mailSenderFactory;
    private final IntegrationChannel channel;
    private final String studioMailAddress;
    private static final Logger logger = Logger.getLogger((String)"dku.notifications.emails");

    public EmailNotificationsSender() throws IOException {
        this(null);
    }

    public EmailNotificationsSender(@Nullable String customChannelId) throws IOException {
        IntegrationChannel channel;
        GeneralSettingsDAO.GeneralSettings settings;
        SpringUtils.getInstance().autowire((Object)this);
        try (Transaction ignored = this.transactionService.retrieveOrBeginRead();){
            settings = this.generalSettingsDAO.read();
            String channelId = EmailNotificationsSender.getChannelId(customChannelId, settings.notifications.emailChannelId);
            channel = this.integrationChannelsDAO.getMandatory(channelId);
        }
        this.channel = channel;
        this.studioMailAddress = settings.studioMailAddress;
    }

    public EmailNotificationsSender(String studioMailAddress, @Nonnull IntegrationChannel channel) throws IOException {
        SpringUtils.getInstance().autowire((Object)this);
        this.channel = channel;
        this.studioMailAddress = studioMailAddress;
    }

    public Future<InfoMessage.InfoMessages> sendToUser(String recipientEmailAddress, UserSettingsService.EmailNotificationsSettings params, String body) throws Exception {
        return this.sendToUser(recipientEmailAddress, params, EmailNotificationsSender.makeHtmlMultipartBody(body));
    }

    public Future<InfoMessage.InfoMessages> sendToUser(String recipientAddress, UserSettingsService.EmailNotificationsSettings params, Multipart content) throws Exception {
        if (!params.enabled) {
            logger.info((Object)"Emails are disabled, not sending");
            InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
            infoMessages.addMessage(InfoMessage.error((String)"Emails disabled", (String)("Mail has not been sent to \"" + recipientAddress + "\" because emails are disabled.")));
            return CompletableFuture.completedFuture(infoMessages);
        }
        Preconditions.checkNotNull((Object)this.channel, (Object)"Messaging channel not specified");
        Preconditions.checkArgument((recipientAddress != null ? 1 : 0) != 0, (Object)"Unknown user email");
        AbstractMailSender sender = this.mailSenderFactory.createMailSenderWithoutPermissionCheck(this.channel);
        String senderAddress = sender.getConfiguration().computeFromField(null, null, this.studioMailAddress);
        Session session = sender.newSession();
        Message msg = this.makeMessage(session, params, senderAddress, recipientAddress, content);
        logger.info((Object)"Message ready to be sent");
        return sender.startSending(session, msg);
    }

    private Message makeMessage(Session session, UserSettingsService.EmailNotificationsSettings params, String senderAddress, String recipientAddress, Multipart content) throws Exception {
        MimeMessage mail = new MimeMessage(session);
        mail.setFrom((Address)this.makeSenderAddress(senderAddress, recipientAddress));
        mail.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipientAddress));
        mail.setSubject(EmailNotificationsSender.makeSubject(params));
        mail.setContent(content);
        return mail;
    }

    private static Multipart makeHtmlMultipartBody(String body) throws MessagingException {
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(body, "utf-8", "html");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        return multipart;
    }

    private static String makeSubject(UserSettingsService.EmailNotificationsSettings params) {
        return StringUtils.isNotBlank((String)params.subject) ? params.subject : "Dataiku DSS report";
    }

    private InternetAddress makeSenderAddress(String senderAddress, String recipientAddress) throws AddressException {
        String parsedSenderAddress;
        if (StringUtils.isNotBlank((String)senderAddress)) {
            VariableLookup lookup = new VariableLookup();
            lookup.setVariablesContext(this.variablesService.getForGlobal());
            StringSubstitutor substitutor = new StringSubstitutor((StringLookup)lookup);
            parsedSenderAddress = substitutor.replace(senderAddress);
        } else {
            parsedSenderAddress = recipientAddress;
        }
        return new InternetAddress(parsedSenderAddress);
    }

    @Nonnull
    private static String getChannelId(@Nullable String customChannelId, String defaultChannelId) {
        String channelId = StringUtils.defaultIfBlank((String)customChannelId, (String)defaultChannelId);
        if (StringUtils.isBlank((String)channelId)) {
            throw new IllegalConfigurationException("The messaging channel for notification emails is not configured.");
        }
        return channelId;
    }
}

