/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.backend;

import com.dataiku.dip.dao.ContinuousActivitiesPersistentStateDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.MarkupFormatter;
import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.notifications.backend.EventWithHumanReadableString;
import com.dataiku.dip.server.notifications.backend.ProjectEvent;
import com.dataiku.dip.server.notifications.backend.UserEvent;

public class ContinuousActivityStateChangedEvent
extends BackendEvent
implements UserEvent,
ProjectEvent,
EventWithHumanReadableString {
    public static final String NAME = "continuous-activity-state-change";
    public final String name = "continuous-activity-state-change";
    public final String projectKey;
    public final String continuousActivityId;
    public final String initiator;
    public final ContinuousActivitiesPersistentStateDAO.DesiredState state;
    public final String humanReadableJobDesc;
    public String initiatorDisplayName;

    public ContinuousActivityStateChangedEvent(AuthCtx authCtx, ContinuousActivitiesPersistentStateDAO.ContinuousActivityPersistentState def) {
        this.projectKey = def.projectKey;
        this.continuousActivityId = def.recipeId;
        this.initiator = authCtx.getAssociatedDSSUser();
        this.state = def.desiredState;
        this.humanReadableJobDesc = def.recipeId + "(" + def.recipeType + ")";
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getUserLogin() {
        return this.initiator;
    }

    @Override
    public String toHumanReadableString(MarkupFormatter markup) {
        String jobMsg = markup.continuousActivity(this.projectKey, this.continuousActivityId, this.humanReadableJobDesc);
        switch (this.state) {
            case STARTED: {
                return "Continuous activity " + jobMsg + " started";
            }
            case STOPPED: {
                return "Continuous activity " + jobMsg + " stopped";
            }
        }
        throw new Error("unreachable");
    }
}

