/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.notifications.emails;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.requestcenter.Request;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.HrefContext;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.server.notifications.backend.AccessRequestEvent;
import com.dataiku.dip.server.notifications.emails.AbstractRequestAccessEmailBuilder;
import com.dataiku.dip.server.notifications.emails.MessageContentBuilder;
import com.dataiku.dip.server.notifications.emails.TemplatedContent;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestAccessEmailBuilder
extends AbstractRequestAccessEmailBuilder<AccessRequestEvent> {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private GeneralSettingsService generalSettingsService;

    public RequestAccessEmailBuilder() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected String makeBody(AccessRequestEvent evt, PublicUser srcUser, SerializedProject project, String objectDisplayName) throws IOException, TemplateException {
        HrefContext href;
        File templateFile = ApplicationConfigurator.getResourceFile((String[])new String[]{"notifications", "access-request-email.ftl"});
        VariableLookup lookup = new VariableLookup();
        SerializedProject targetProject = null;
        try (Transaction ignored = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings settings = this.generalSettingsService.read();
            lookup.addVariable("studioExternalUrl", StringUtils.isBlank((String)settings.studioExternalUrl) ? null : settings.studioExternalUrl);
            lookup.addVariable("dssInstanceName", settings.nodeName);
            lookup.addVariable("emailPreferencesLink", settings.studioExternalUrl + "/profile/");
            href = new HrefContext(settings.studioExternalUrl);
            if (evt.getRequestType().isSharingRequest()) {
                targetProject = this.projectsService.getMandatory(evt.getTargetProjectKey());
            }
        }
        lookup.addVariable("objectType", (Object)evt.getObjectType());
        lookup.addVariable("requesterName", srcUser.displayName);
        lookup.addVariable("requesterLink", href.user(srcUser.login));
        lookup.addVariable("projectName", project.name);
        lookup.addVariable("requestLink", href.request(evt.getRequestId()));
        if (StringUtils.isNotBlank((String)evt.getMessage())) {
            lookup.addVariable("message", evt.getMessage());
        }
        if (evt.getRequestType().isSharingRequest()) {
            String objectTypeName = evt.getObjectType().toTaggableType().get().toHumanReadableString();
            lookup.addVariable("title", "Share access to a " + objectTypeName + "?");
            lookup.addVariable("requestAction", "requested to use a " + objectTypeName + " in a project");
            lookup.addVariable("projectLink", href.project(project.projectKey));
            lookup.addVariable("iconPath", this.getObjectIconPath(evt));
            lookup.addVariable("objectName", objectDisplayName);
            lookup.addVariable("objectLink", this.getObjectLink(evt, href));
            lookup.addVariable("projectSecurityLinkName", "Edit shared objects settings");
            lookup.addVariable("projectSecurityLink", href.project(project.projectKey) + "security/exposed");
            if (targetProject != null) {
                lookup.addVariable("targetProjectLink", href.project(targetProject.projectKey));
                lookup.addVariable("targetProjectName", targetProject.name);
            }
        } else if (evt.getObjectType() == Request.RequestObjectType.PROJECT) {
            lookup.addVariable("title", "Grant access to a project?");
            lookup.addVariable("requestAction", "requested access to a project");
            lookup.addVariable("projectLink", href.project(project.projectKey));
            lookup.addVariable("projectSecurityLinkName", "Edit project security settings");
            lookup.addVariable("projectSecurityLink", href.project(project.projectKey) + "security/permissions");
        } else if (evt.getObjectType() == Request.RequestObjectType.APP) {
            lookup.addVariable("title", "Grant right to execute application?");
            lookup.addVariable("requestAction", "requested to execute application");
            lookup.addVariable("projectLink", href.application(evt.getObjectId()));
            lookup.addVariable("projectSecurityLinkName", "Edit project security settings");
            lookup.addVariable("projectSecurityLink", href.project(project.projectKey) + "security/permissions");
        }
        MessageContentBuilder.ExpandedTemplate expandedTemplate = new MessageContentBuilder(lookup).buildMessage(new TemplatedContent(), templateFile);
        return expandedTemplate.message;
    }

    @Override
    protected String makeSubject(AccessRequestEvent evt, PublicUser srcUser, String objectDisplayName) {
        return srcUser.displayName + " requested " + (switch (evt.getRequestType()) {
            case Request.RequestType.PROJECT_READ -> "access to";
            case Request.RequestType.PROJECT_WRITE -> "write access to";
            case Request.RequestType.PROJECT_EXECUTE_APP -> "to execute";
            case Request.RequestType.OBJECT_SHARE -> "to share";
            default -> throw new IllegalStateException("Unknown request type " + String.valueOf((Object)evt.getRequestType()));
        }) + " " + objectDisplayName;
    }
}

