/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.transform;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.SingleRowProcessor;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class ColumnCopier
extends SingleRowProcessor
implements Processor {
    public static final ProcessorMeta<ColumnCopier, Parameter> META = new ProcessorMeta<ColumnCopier, Parameter>(){

        @Override
        public String getName() {
            return "ColumnCopier";
        }

        @Override
        public String getDocPage() {
            return "column-copy";
        }

        @Override
        public Category getCategory() {
            return Category.TRANSFORMATION;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.MISC});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.ColumnCopier.HELP", "Duplicate the content of a column into another one.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.ColumnCopier.DESCRIPTION", 1.actionVerb("Copy") + " column")).withMNEColParam("inputColumn", this.translate(language, "SHAKER.PROCESSOR.ColumnCopier.DESCRIPTION.INPUT_COLUMN", "Copy from column")).withParam("outputColumn", "string", true, false, this.translate(language, "SHAKER.PROCESSOR.ColumnCopier.DESCRIPTION.OUTPUT_COLUMN", "Into column"));
        }

        @Override
        public ColumnCopier build(Parameter parameter) {
            return new ColumnCopier(parameter);
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams sp, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.transform.ColumnCopierNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            RecipeLineage updatedRecipeLineage = new RecipeLineage();
            previousRecipeLineage.getDatasetPairLineages().forEach((datasetPair, previousDatasetPairLineage) -> {
                DatasetPairLineage updatedDatasetPairLineage = new DatasetPairLineage((DatasetPairLineage)previousDatasetPairLineage);
                Parameter copierParams = (Parameter)pss.params;
                if (!Objects.equals(copierParams.inputColumn, copierParams.outputColumn)) {
                    updatedDatasetPairLineage.removeRelationsOnColumn(copierParams.outputColumn);
                }
                updatedDatasetPairLineage.addFactorizedColumnRelations(copierParams.inputColumn, copierParams.outputColumn);
                updatedRecipeLineage.setDatasetPairLineage((Pair<String, String>)datasetPair, updatedDatasetPairLineage);
            });
            return updatedRecipeLineage;
        }
    };
    private final Parameter parameter;
    private Column inCD;
    private Column outCD;

    public ColumnCopier(Parameter parameter) {
        this.parameter = parameter;
    }

    public void init() {
        this.inCD = this.getColumnFactory().column(this.parameter.inputColumn, Processor.ProcessorRole.INPUT_COLUMN);
        this.outCD = this.getColumnFactory().columnAfter(this.parameter.inputColumn, this.parameter.outputColumn, Processor.ProcessorRole.OUTPUT_COLUMN);
    }

    public void processRow(Row row) throws Exception {
        String v = row.get(this.inCD);
        if (v != null) {
            row.put(this.outCD, v);
        } else {
            String existing = row.get(this.outCD);
            if (existing != null) {
                row.put(this.outCD, null);
            }
        }
    }

    public void postProcess() {
    }

    public static class Parameter
    implements StepParams {
        private static final long serialVersionUID = -1L;
        public String inputColumn;
        public String outputColumn;

        public void validate() throws IllegalArgumentException {
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter params;

        private SQLTranslator(Parameter params) {
            this.params = params;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema chain) {
            ArrayList allNames = Lists.newArrayList((Object[])new String[]{this.params.inputColumn, this.params.outputColumn});
            if (chain.isAnyCreatedOrModifiedByCurrentQuery(allNames)) {
                chain = chain.makeSubquery();
            }
            if (chain.getCurrentColumn(this.params.outputColumn) != null) {
                SchemaColumn merged = chain.getMandatoryCurrentColumn(this.params.outputColumn);
                chain.coalesceSelect(this.params.outputColumn, chain.col(this.params.inputColumn).cast(merged.getType(), merged.getMaxLength()), this.params.outputColumn);
            } else {
                SchemaColumn schemaColumn = chain.getMandatoryCurrentColumn(this.params.inputColumn);
                SchemaColumn renamed = (SchemaColumn)JSON.deepCopy((Object)schemaColumn);
                renamed.setName(this.params.outputColumn);
                chain.addColumnAfter(this.params.inputColumn, renamed);
                chain.select(chain.col(this.params.inputColumn), this.params.outputColumn);
            }
            return chain;
        }
    }
}

