/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;

public class DKUIOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long copyLarge(InputStream input, OutputStream output, CopyCallback callback) throws IOException, InterruptedException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            if (callback == null || callback.update(count += (long)n)) continue;
            throw new InterruptedException("Cancelled by user callback");
        }
        return count;
    }

    public static long copyLarge(InputStream input, OutputStream output, long length, CopyCallback callback) throws IOException, InterruptedException {
        int n;
        int readLen;
        if (length == 0L) {
            return 0L;
        }
        byte[] buffer = new byte[8192];
        long count = 0L;
        int n2 = readLen = length > 0L && length < (long)buffer.length ? (int)length : buffer.length;
        while (readLen > 0 && -1 != (n = input.read(buffer, 0, readLen))) {
            output.write(buffer, 0, n);
            if (length > 0L && length - (count += (long)n) < (long)buffer.length) {
                readLen = (int)(length - count);
            }
            if (callback == null || callback.update(count)) continue;
            throw new InterruptedException("Cancelled by user callback");
        }
        return count;
    }

    public static <T> File extractResource(String resourceName, File outputDirectory, Class<T> clazz) throws IOException {
        try (InputStream input = clazz.getResourceAsStream(resourceName);){
            File outputFile = new File(outputDirectory, resourceName);
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            ByteStreams.copy((InputStream)input, (OutputStream)outputStream);
            File file = outputFile;
            return file;
        }
    }

    public static String getResourceFileContent(Class<?> clazz, String resourceName) throws IOException {
        InputStream is = clazz.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Error("Can't open resource file " + resourceName);
        }
        if (resourceName.endsWith(".gz")) {
            is = new GZIPInputStream(is);
        }
        byte[] data = ByteStreams.toByteArray((InputStream)is);
        return new String(data, "utf8");
    }

    public static byte[] toByteArray(ByteBuffer buffer, int length) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0) {
            return buffer.array();
        }
        byte[] data = new byte[length];
        buffer.get(data);
        return data;
    }

    public static interface CopyCallback {
        public boolean update(long var1);
    }
}

