/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.wikis;

import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.wikis.Wiki;
import com.dataiku.dip.wikis.WikisDAO;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FilesBasedWikisDAO
implements WikisDAO {
    @Override
    public Wiki get(String projectKey) throws IOException {
        return this.get(projectKey, false);
    }

    @Override
    public Wiki getUnsafe(String projectKey) throws IOException {
        return this.get(projectKey, true);
    }

    @Override
    public void save(Wiki wiki) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile taxonomyFile = this.getTaxonomyFile(wiki.projectKey);
        if (wiki.taxonomy != null && !wiki.taxonomy.isEmpty()) {
            if (StringUtils.isBlank((String)wiki.homeArticleId)) {
                wiki.homeArticleId = wiki.taxonomy.get((int)0).id;
            }
            t.writeObject(taxonomyFile, (Object)wiki);
        } else if (t.isFile(taxonomyFile)) {
            t.deleteFile(taxonomyFile);
        }
    }

    private Wiki get(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        Wiki wiki = null;
        RelFile taxonomyFile = this.getTaxonomyFile(projectKey);
        wiki = t.isFile(taxonomyFile) ? (unsafe ? (Wiki)t.readObjectUnsafe(taxonomyFile, Wiki.class) : (Wiki)t.readObject(taxonomyFile, Wiki.class)) : new Wiki();
        wiki.projectKey = projectKey;
        return wiki;
    }

    private RelFile getTaxonomyFile(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Wiki project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "wiki", "taxonomy.json"});
    }
}

