/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.dataiku;

import com.google.gson.JsonArray;
import com.google.refine.expr.EvalError;
import com.google.refine.expr.ExpressionUtils;
import com.google.refine.expr.functions.strings.ParseJson;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;

public class DKUArrayLen
implements Function {
    private ParseJson parser = new ParseJson();

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 0) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one argument");
        }
        if (args[0] == null) {
            return 0;
        }
        if (args[0] instanceof Object[]) {
            return ((Object[])args[0]).length;
        }
        if (args[0] instanceof JSONArray) {
            return ((JSONArray)args[0]).length();
        }
        if (args[0] instanceof JsonArray) {
            return ((JsonArray)args[0]).size();
        }
        if (args[0] instanceof List) {
            return ((List)args[0]).size();
        }
        if (args[0] instanceof String) {
            Object v = this.parser.call(bindings, args);
            if (ExpressionUtils.isError(v)) {
                return v;
            }
            return ((JSONArray)v).length();
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an array or a String");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.DKUArrayLen.DOCUMENTATION", "Returns the length of an array.").withParams("array a").withReturns("int").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("[4,5,6]").returns("3"));
    }
}

