/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class LeastCommonMultiple
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2 && args[0] != null && args[0] instanceof Number && args[1] != null && args[1] instanceof Number) {
            return LeastCommonMultiple.LCM(((Number)args[0]).doubleValue(), ((Number)args[1]).doubleValue());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects two numbers");
    }

    public static double LCM(double a, double b) {
        double largerValue = a;
        double smallerValue = b;
        if (b > a) {
            largerValue = b;
            smallerValue = a;
        }
        int i = 1;
        while ((double)i <= largerValue) {
            if (largerValue * (double)i % smallerValue == 0.0) {
                return largerValue * (double)i;
            }
            ++i;
        }
        return largerValue * smallerValue;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.LeastCommonMultiple.DOCUMENTATION", "Returns the least common multiple of the two numbers.").withParams("number d, number e").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("20", "42").returns("420.0"));
    }
}

