/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.math;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.math.FactN;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Multinomial
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length < 1) {
            return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects one or more numbers");
        }
        int sum = 0;
        int product = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !(args[i] instanceof Number)) {
                return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects parameter " + (i + 1) + " to be a number");
            }
            int num = ((Number)args[i]).intValue();
            sum += num;
            product = (int)((long)product * FactN.factorial(num, 1L));
        }
        return FactN.factorial(sum, 1L) / (long)product;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Multinomial.DOCUMENTATION", "Returns the multinomial of a series of numbers: <code>(sum(d1,d2,d3,...))! / (d1! * d2! * d3! * ...)</code>").withParams("number d1, number d2 ...").withReturns("number").withCategory("GREL.FUNCTIONS.CATEGORY.MATHS", "Maths functions").withExample(Example.with("1", "1", "2", "1").returns("60"));
    }
}

