/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.snowflake.ingest.internal.com.nimbusds.jose.EncryptionMethod;
import net.snowflake.ingest.internal.com.nimbusds.jose.JOSEException;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEAlgorithm;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWECryptoParts;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEEncrypter;
import net.snowflake.ingest.internal.com.nimbusds.jose.JWEHeader;
import net.snowflake.ingest.internal.com.nimbusds.jose.KeyLengthException;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.Base64URL;
import net.snowflake.ingest.internal.com.nimbusds.jose.util.ByteUtils;
import net.snowflake.ingest.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DirectEncrypter
extends DirectCryptoProvider
implements JWEEncrypter {
    public DirectEncrypter(SecretKey key) throws KeyLengthException {
        super(key);
    }

    public DirectEncrypter(byte[] keyBytes) throws KeyLengthException {
        this(new SecretKeySpec(keyBytes, "AES"));
    }

    public DirectEncrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader header, byte[] clearText) throws JOSEException {
        JWEAlgorithm alg = header.getAlgorithm();
        if (!alg.equals(JWEAlgorithm.DIR)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod enc = header.getEncryptionMethod();
        if (enc.cekBitLength() != ByteUtils.safeBitLength(this.getKey().getEncoded())) {
            throw new KeyLengthException(enc.cekBitLength(), enc);
        }
        Base64URL encryptedKey = null;
        return ContentCryptoProvider.encrypt(header, clearText, this.getKey(), encryptedKey, this.getJCAContext());
    }
}

