/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.com.nimbusds.jose.jwk.source;

import javax.crypto.SecretKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.JWKSet;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.OctetSequenceKey;
import net.snowflake.ingest.internal.com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import net.snowflake.ingest.internal.com.nimbusds.jose.proc.SecurityContext;
import net.snowflake.ingest.internal.net.jcip.annotations.Immutable;

@Immutable
public class ImmutableSecret<C extends SecurityContext>
extends ImmutableJWKSet<C> {
    public ImmutableSecret(byte[] secret) {
        super(new JWKSet(new OctetSequenceKey.Builder(secret).build()));
    }

    public ImmutableSecret(SecretKey secretKey) {
        super(new JWKSet(new OctetSequenceKey.Builder(secretKey).build()));
    }

    public byte[] getSecret() {
        return ((OctetSequenceKey)this.getJWKSet().getKeys().get(0)).toByteArray();
    }

    public SecretKey getSecretKey() {
        return ((OctetSequenceKey)this.getJWKSet().getKeys().get(0)).toSecretKey();
    }
}

