/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.io.swagger.parser;

import com.dataiku.dss.shadelib.io.swagger.models.Operation;
import com.dataiku.dss.shadelib.io.swagger.models.Path;
import com.dataiku.dss.shadelib.io.swagger.models.Swagger;
import com.dataiku.dss.shadelib.io.swagger.models.auth.AuthorizationValue;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.Parameter;
import com.dataiku.dss.shadelib.io.swagger.models.parameters.RefParameter;
import com.dataiku.dss.shadelib.io.swagger.models.refs.RefFormat;
import com.dataiku.dss.shadelib.io.swagger.parser.ResolverCache;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.DefinitionsProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.OperationProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.ParameterProcessor;
import com.dataiku.dss.shadelib.io.swagger.parser.processors.PathsProcessor;
import java.util.Arrays;
import java.util.List;

public class SwaggerResolver {
    private final Swagger swagger;
    private final ResolverCache cache;
    private final PathsProcessor pathProcessor;
    private final DefinitionsProcessor definitionsProcessor;
    private final OperationProcessor operationsProcessor;
    private final ParameterProcessor parametersProcessor;
    private Settings settings = new Settings();

    public SwaggerResolver(Swagger swagger) {
        this(swagger, null, null, null);
    }

    public SwaggerResolver(Swagger swagger, List<AuthorizationValue> auths) {
        this(swagger, auths, null, null);
    }

    public SwaggerResolver(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation) {
        this(swagger, auths, parentFileLocation, null);
    }

    public SwaggerResolver(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation, Settings settings) {
        this.swagger = swagger;
        this.settings = settings != null ? settings : new Settings();
        this.cache = new ResolverCache(swagger, auths, parentFileLocation);
        this.definitionsProcessor = new DefinitionsProcessor(this.cache, swagger);
        this.pathProcessor = new PathsProcessor(this.cache, swagger, this.settings);
        this.operationsProcessor = new OperationProcessor(this.cache, swagger);
        this.parametersProcessor = new ParameterProcessor(this.cache, swagger);
    }

    public Swagger resolve() {
        if (this.swagger == null) {
            return null;
        }
        if (this.swagger.getParameters() != null) {
            for (String paramname : this.swagger.getParameters().keySet()) {
                Parameter param = this.swagger.getParameters().get(paramname);
                if (!(param instanceof RefParameter) || ((RefParameter)param).getRefFormat() != RefFormat.RELATIVE) continue;
                this.swagger.getParameters().put(paramname, this.parametersProcessor.processParameters(Arrays.asList(param)).get(0));
            }
        }
        this.pathProcessor.processPaths();
        this.definitionsProcessor.processDefinitions();
        if (this.swagger.getPaths() != null) {
            for (String pathname : this.swagger.getPaths().keySet()) {
                Path path = this.swagger.getPaths().get(pathname);
                if (path.getOperations() == null) continue;
                for (Operation operation : path.getOperations()) {
                    this.operationsProcessor.processOperation(operation);
                }
            }
        }
        return this.swagger;
    }

    public static class Settings {
        private boolean addParametersToEachOperation = true;

        public boolean addParametersToEachOperation() {
            return this.addParametersToEachOperation;
        }

        public Settings addParametersToEachOperation(boolean addParametersToEachOperation) {
            this.addParametersToEachOperation = addParametersToEachOperation;
            return this;
        }
    }
}

