/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.pattern;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.charfilter.BaseCharFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternReplaceCharFilter
extends BaseCharFilter {
    private final Pattern pattern;
    private final String replacement;
    private Reader transformedInput;

    public PatternReplaceCharFilter(Pattern pattern, String replacement, Reader in) {
        super(in);
        this.pattern = Objects.requireNonNull(pattern, "pattern");
        this.replacement = Objects.requireNonNull(replacement, "replacement");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read(cbuf, off, len);
    }

    private void fill() throws IOException {
        StringBuilder buffered = new StringBuilder();
        char[] temp = new char[1024];
        int cnt = this.input.read(temp);
        while (cnt > 0) {
            buffered.append(temp, 0, cnt);
            cnt = this.input.read(temp);
        }
        this.transformedInput = new StringReader(this.processPattern(buffered).toString());
    }

    @Override
    public int read() throws IOException {
        if (this.transformedInput == null) {
            this.fill();
        }
        return this.transformedInput.read();
    }

    @Override
    protected int correct(int currentOff) {
        return Math.max(0, super.correct(currentOff));
    }

    CharSequence processPattern(CharSequence input) {
        Matcher m4 = this.pattern.matcher(input);
        StringBuffer cumulativeOutput = new StringBuffer();
        int cumulative = 0;
        int lastMatchEnd = 0;
        while (m4.find()) {
            int groupSize = m4.end() - m4.start();
            int skippedSize = m4.start() - lastMatchEnd;
            lastMatchEnd = m4.end();
            int lengthBeforeReplacement = cumulativeOutput.length() + skippedSize;
            m4.appendReplacement(cumulativeOutput, this.replacement);
            int replacementSize = cumulativeOutput.length() - lengthBeforeReplacement;
            if (groupSize == replacementSize) continue;
            if (replacementSize < groupSize) {
                int atIndex = lengthBeforeReplacement + replacementSize;
                this.addOffCorrectMap(atIndex, cumulative += groupSize - replacementSize);
                continue;
            }
            for (int i = groupSize; i < replacementSize; ++i) {
                this.addOffCorrectMap(lengthBeforeReplacement + i, --cumulative);
            }
        }
        m4.appendTail(cumulativeOutput);
        return cumulativeOutput;
    }
}

