/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc;

import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.AbstractIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.BitMixer;
import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.FloatCursor;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Accountable;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import java.util.Arrays;
import java.util.Iterator;

public class FloatArrayList
implements Iterable<FloatCursor>,
Cloneable,
Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FloatArrayList.class);
    public static final float[] EMPTY_ARRAY = new float[0];
    public float[] buffer;
    public int elementsCount;

    public FloatArrayList() {
        this(4);
    }

    public FloatArrayList(int expectedElements) {
        this.buffer = new float[expectedElements];
    }

    public FloatArrayList(FloatArrayList list) {
        this(list.size());
        this.addAll(list);
    }

    public void add(float e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(float[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public final void add(float ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(FloatArrayList list) {
        int size = list.size();
        this.ensureBufferSpace(size);
        for (FloatCursor cursor : list) {
            this.add(cursor.value);
        }
        return size;
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.add(floatCursor.value);
            ++size;
        }
        return size;
    }

    public void insert(int index, float e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [0, " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    public float get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        return this.buffer[index];
    }

    public float set(int index, float e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        float v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    public float removeAt(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [0, " + this.size() + ").";
        float v = this.buffer[index];
        System.arraycopy(this.buffer, index + 1, this.buffer, index, --this.elementsCount - index);
        return v;
    }

    public float removeLast() {
        assert (!this.isEmpty()) : "List is empty";
        return this.buffer[--this.elementsCount];
    }

    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [0, " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [0, " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    public boolean removeElement(float e) {
        return this.removeFirst(e) != -1;
    }

    public int removeFirst(float e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeLast(float e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.removeAt(index);
        }
        return index;
    }

    public int removeAll(float e) {
        int to = 0;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e == this.buffer[from]) continue;
            if (to != from) {
                this.buffer[to] = this.buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    public boolean contains(float e1) {
        return this.indexOf(e1) >= 0;
    }

    public int indexOf(float e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != this.buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.buffer.length) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        if (this.elementsCount + expectedAdditions > this.buffer.length) {
            this.buffer = ArrayUtil.grow(this.buffer, this.elementsCount + expectedAdditions);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, 0.0f);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0.0f);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, 0.0f);
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    public float[] toArray() {
        return ArrayUtil.copyOfSubArray(this.buffer, 0, this.elementsCount);
    }

    public FloatArrayList clone() {
        try {
            FloatArrayList cloned = (FloatArrayList)super.clone();
            cloned.buffer = (float[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        for (int i = 0; i < max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(this.buffer[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((FloatArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(FloatArrayList other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.buffer);
    }

    public FloatArrayList sort() {
        Arrays.sort(this.buffer, 0, this.elementsCount);
        return this;
    }

    public FloatArrayList reverse() {
        int i = 0;
        int mid = this.elementsCount >> 1;
        int j = this.elementsCount - 1;
        while (i < mid) {
            float tmp = this.buffer[i];
            this.buffer[i] = this.buffer[j];
            this.buffer[j] = tmp;
            ++i;
            --j;
        }
        return this;
    }

    @Override
    public Iterator<FloatCursor> iterator() {
        return new ValueIterator(this.buffer, this.size());
    }

    public static FloatArrayList from(float ... elements) {
        FloatArrayList list = new FloatArrayList(elements.length);
        list.add(elements);
        return list;
    }

    static final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final float[] buffer;
        private final int size;

        public ValueIterator(float[] buffer, int size) {
            this.cursor.index = -1;
            this.size = size;
            this.buffer = buffer;
        }

        @Override
        protected FloatCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (FloatCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

