/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.spans;

import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanDisiWrapper;
import java.util.Arrays;
import java.util.Iterator;

final class SpanDisiPriorityQueue
implements Iterable<SpanDisiWrapper> {
    private final SpanDisiWrapper[] heap;
    private int size;

    static int leftNode(int node) {
        return (node + 1 << 1) - 1;
    }

    static int rightNode(int leftNode) {
        return leftNode + 1;
    }

    static int parentNode(int node) {
        return (node + 1 >>> 1) - 1;
    }

    public SpanDisiPriorityQueue(int maxSize) {
        this.heap = new SpanDisiWrapper[maxSize];
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public SpanDisiWrapper top() {
        return this.heap[0];
    }

    public SpanDisiWrapper topList() {
        SpanDisiWrapper[] heap = this.heap;
        int size = this.size;
        SpanDisiWrapper list = heap[0];
        list.next = null;
        if (size >= 3) {
            list = this.topList(list, heap, size, 1);
            list = this.topList(list, heap, size, 2);
        } else if (size == 2 && heap[1].doc == list.doc) {
            list = this.prepend(heap[1], list);
        }
        return list;
    }

    private SpanDisiWrapper prepend(SpanDisiWrapper w1, SpanDisiWrapper w2) {
        w1.next = w2;
        return w1;
    }

    private SpanDisiWrapper topList(SpanDisiWrapper list, SpanDisiWrapper[] heap, int size, int i) {
        SpanDisiWrapper w = heap[i];
        if (w.doc == list.doc) {
            list = this.prepend(w, list);
            int left = SpanDisiPriorityQueue.leftNode(i);
            int right = left + 1;
            if (right < size) {
                list = this.topList(list, heap, size, left);
                list = this.topList(list, heap, size, right);
            } else if (left < size && heap[left].doc == list.doc) {
                list = this.prepend(heap[left], list);
            }
        }
        return list;
    }

    public SpanDisiWrapper add(SpanDisiWrapper entry) {
        SpanDisiWrapper[] heap = this.heap;
        int size = this.size;
        heap[size] = entry;
        this.upHeap(size);
        this.size = size + 1;
        return heap[0];
    }

    public SpanDisiWrapper pop() {
        SpanDisiWrapper[] heap = this.heap;
        SpanDisiWrapper result = heap[0];
        int i = --this.size;
        heap[0] = heap[i];
        heap[i] = null;
        this.downHeap(i);
        return result;
    }

    public SpanDisiWrapper updateTop() {
        this.downHeap(this.size);
        return this.heap[0];
    }

    SpanDisiWrapper updateTop(SpanDisiWrapper topReplacement) {
        this.heap[0] = topReplacement;
        return this.updateTop();
    }

    void upHeap(int i) {
        SpanDisiWrapper node = this.heap[i];
        int nodeDoc = node.doc;
        int j = SpanDisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeDoc < this.heap[j].doc) {
            this.heap[i] = this.heap[j];
            i = j;
            j = SpanDisiPriorityQueue.parentNode(j);
        }
        this.heap[i] = node;
    }

    void downHeap(int size) {
        int i = 0;
        SpanDisiWrapper node = this.heap[0];
        int j = SpanDisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = SpanDisiPriorityQueue.rightNode(j);
            if (k < size && this.heap[k].doc < this.heap[j].doc) {
                j = k;
            }
            if (this.heap[j].doc < node.doc) {
                do {
                    this.heap[i] = this.heap[j];
                    i = j;
                    k = SpanDisiPriorityQueue.rightNode(j = SpanDisiPriorityQueue.leftNode(i));
                    if (k >= size || this.heap[k].doc >= this.heap[j].doc) continue;
                    j = k;
                } while (j < size && this.heap[j].doc < node.doc);
                this.heap[i] = node;
            }
        }
    }

    @Override
    public Iterator<SpanDisiWrapper> iterator() {
        return Arrays.asList(this.heap).subList(0, this.size).iterator();
    }
}

