/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermStates;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.search.MultiTermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.util.AttributeSource;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;

abstract class TermCollectingRewrite<B>
extends MultiTermQuery.RewriteMethod {
    TermCollectingRewrite() {
    }

    protected abstract B getTopLevelBuilder() throws IOException;

    protected abstract Query build(B var1);

    protected final void addClause(B topLevel, Term term, int docCount, float boost) throws IOException {
        this.addClause(topLevel, term, docCount, boost, null);
    }

    protected abstract void addClause(B var1, Term var2, int var3, float var4, TermStates var5) throws IOException;

    final void collectTerms(IndexReader reader, MultiTermQuery query, TermCollector collector) throws IOException {
        IndexReaderContext topReaderContext = reader.getContext();
        for (LeafReaderContext context : topReaderContext.leaves()) {
            BytesRef bytes;
            Terms terms = context.reader().terms(query.field);
            if (terms == null) continue;
            TermsEnum termsEnum = this.getTermsEnum(query, terms, collector.attributes);
            assert (termsEnum != null);
            if (termsEnum == TermsEnum.EMPTY) continue;
            collector.setReaderContext(topReaderContext, context);
            collector.setNextEnum(termsEnum);
            while ((bytes = termsEnum.next()) != null) {
                if (collector.collect(bytes)) continue;
                return;
            }
        }
    }

    static abstract class TermCollector {
        protected LeafReaderContext readerContext;
        protected IndexReaderContext topReaderContext;
        public final AttributeSource attributes = new AttributeSource();

        TermCollector() {
        }

        public void setReaderContext(IndexReaderContext topReaderContext, LeafReaderContext readerContext) {
            this.readerContext = readerContext;
            this.topReaderContext = topReaderContext;
        }

        public abstract boolean collect(BytesRef var1) throws IOException;

        public abstract void setNextEnum(TermsEnum var1) throws IOException;
    }
}

