/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util;

import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayIntroSorter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayTimSorter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BitUtil;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Constants;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IntroSelector;
import com.dataiku.dss.shadelib.org.apache.lucene.util.RamUsageEstimator;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;

    private ArrayUtil() {
    }

    public static int parseInt(char[] chars, int offset, int len) throws NumberFormatException {
        return ArrayUtil.parseInt(chars, offset, len, 10);
    }

    public static int parseInt(char[] chars, int offset, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars[offset + i] == '-';
        if (negative && ++i == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset;
            --len;
        }
        return ArrayUtil.parse(chars, offset, len, radix, negative);
    }

    private static int parse(char[] chars, int offset, int len, int radix, boolean negative) throws NumberFormatException {
        int max = Integer.MIN_VALUE / radix;
        int result = 0;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit(chars[i + offset], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max > result) {
                throw new NumberFormatException("Unable to parse");
            }
            int next = result * radix - digit;
            if (next > result) {
                throw new NumberFormatException("Unable to parse");
            }
            result = next;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 1: {
                return (newSize + 3 & 0x7FFFFFF8) + 4;
            }
            case 2: {
                return (newSize + 1 & 0x7FFFFFFC) + 2;
            }
            case 4: {
                return (newSize & 0x7FFFFFFE) + 1;
            }
        }
        return newSize;
    }

    public static <T> T[] growExact(T[] array, int newLength) {
        Class<?> type = array.getClass();
        Object[] copy = type == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(type.getComponentType(), newLength);
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static <T> T[] grow(T[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static <T> T[] grow(T[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            int newLength = ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            return ArrayUtil.growExact(array, newLength);
        }
        return array;
    }

    public static short[] growExact(short[] array, int newLength) {
        short[] copy = new short[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static short[] grow(short[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static short[] grow(short[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static float[] growExact(float[] array, int newLength) {
        float[] copy = new float[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static float[] grow(float[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            float[] copy = new float[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return array;
    }

    public static float[] grow(float[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static double[] growExact(double[] array, int newLength) {
        double[] copy = new double[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static double[] grow(double[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static double[] grow(double[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int[] growExact(int[] array, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static int[] growInRange(int[] array, int minLength, int maxLength) {
        assert (minLength >= 0) : "length must be positive (got " + minLength + "): likely integer overflow?";
        if (minLength > maxLength) {
            throw new IllegalArgumentException("requested minimum array length " + minLength + " is larger than requested maximum array length " + maxLength);
        }
        if (array.length >= minLength) {
            return array;
        }
        int potentialLength = ArrayUtil.oversize(minLength, 4);
        return ArrayUtil.growExact(array, Math.min(maxLength, potentialLength));
    }

    public static int[] grow(int[] array, int minSize) {
        return ArrayUtil.growInRange(array, minSize, Integer.MAX_VALUE);
    }

    public static int[] growNoCopy(int[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return new int[ArrayUtil.oversize(minSize, 4)];
        }
        return array;
    }

    public static int[] grow(int[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static long[] growExact(long[] array, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static long[] grow(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 8));
        }
        return array;
    }

    public static long[] growNoCopy(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return new long[ArrayUtil.oversize(minSize, 8)];
        }
        return array;
    }

    public static long[] grow(long[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static byte[] growExact(byte[] array, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static byte[] grow(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 1));
        }
        return array;
    }

    public static byte[] growNoCopy(byte[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return new byte[ArrayUtil.oversize(minSize, 1)];
        }
        return array;
    }

    public static byte[] grow(byte[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static char[] growExact(char[] array, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(array, 0, copy, 0, array.length);
        return copy;
    }

    public static char[] grow(char[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            return ArrayUtil.growExact(array, ArrayUtil.oversize(minSize, 2));
        }
        return array;
    }

    public static char[] grow(char[] array) {
        return ArrayUtil.grow(array, 1 + array.length);
    }

    public static int hashCode(char[] array, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array[i];
        }
        return code;
    }

    public static <T> void swap(T[] arr, int i, int j) {
        T tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T> void introSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayIntroSorter<T>(a, comp).sort(fromIndex, toIndex);
    }

    public static <T> void introSort(T[] a, Comparator<? super T> comp) {
        ArrayUtil.introSort(a, 0, a.length, comp);
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.introSort(a, fromIndex, toIndex, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a) {
        ArrayUtil.introSort(a, (int)0, (int)a.length);
    }

    public static <T> void timSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayTimSorter<T>(a, comp, a.length / 64).sort(fromIndex, toIndex);
    }

    public static <T> void timSort(T[] a, Comparator<? super T> comp) {
        ArrayUtil.timSort(a, 0, a.length, comp);
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.timSort(a, fromIndex, toIndex, Comparator.naturalOrder());
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a) {
        ArrayUtil.timSort(a, (int)0, (int)a.length);
    }

    public static <T> void select(final T[] arr, int from, int to, int k, final Comparator<? super T> comparator) {
        new IntroSelector(){
            T pivot;

            @Override
            protected void swap(int i, int j) {
                ArrayUtil.swap(arr, i, j);
            }

            @Override
            protected void setPivot(int i) {
                this.pivot = arr[i];
            }

            @Override
            protected int comparePivot(int j) {
                return comparator.compare(this.pivot, arr[j]);
            }
        }.select(from, to, k);
    }

    public static byte[] copyArray(byte[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static byte[] copyOfSubArray(byte[] array, int from, int to) {
        byte[] copy = new byte[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static char[] copyArray(char[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static char[] copyOfSubArray(char[] array, int from, int to) {
        char[] copy = new char[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static short[] copyArray(short[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static short[] copyOfSubArray(short[] array, int from, int to) {
        short[] copy = new short[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static int[] copyArray(int[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static int[] copyOfSubArray(int[] array, int from, int to) {
        int[] copy = new int[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static long[] copyArray(long[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static long[] copyOfSubArray(long[] array, int from, int to) {
        long[] copy = new long[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static float[] copyArray(float[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static float[] copyOfSubArray(float[] array, int from, int to) {
        float[] copy = new float[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static double[] copyArray(double[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static double[] copyOfSubArray(double[] array, int from, int to) {
        double[] copy = new double[to - from];
        System.arraycopy(array, from, copy, 0, to - from);
        return copy;
    }

    public static <T> T[] copyArray(T[] array) {
        return ArrayUtil.copyOfSubArray(array, 0, array.length);
    }

    public static <T> T[] copyOfSubArray(T[] array, int from, int to) {
        int subLength = to - from;
        Class<?> type = array.getClass();
        Object[] copy = type == Object[].class ? new Object[subLength] : (Object[])Array.newInstance(type.getComponentType(), subLength);
        System.arraycopy(array, from, copy, 0, subLength);
        return copy;
    }

    public static ByteArrayComparator getUnsignedComparator(int numBytes) {
        if (numBytes == 8) {
            return ArrayUtil::compareUnsigned8;
        }
        if (numBytes == 4) {
            return ArrayUtil::compareUnsigned4;
        }
        return (a, aOffset, b, bOffset) -> Arrays.compareUnsigned(a, aOffset, aOffset + numBytes, b, bOffset, bOffset + numBytes);
    }

    public static int compareUnsigned8(byte[] a, int aOffset, byte[] b, int bOffset) {
        return Long.compareUnsigned(BitUtil.VH_BE_LONG.get(a, aOffset), BitUtil.VH_BE_LONG.get(b, bOffset));
    }

    public static int compareUnsigned4(byte[] a, int aOffset, byte[] b, int bOffset) {
        return Integer.compareUnsigned(BitUtil.VH_BE_INT.get(a, aOffset), BitUtil.VH_BE_INT.get(b, bOffset));
    }

    @FunctionalInterface
    public static interface ByteArrayComparator {
        public int compare(byte[] var1, int var2, byte[] var3, int var4);
    }
}

