/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.ComplianceViolationException;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.CookieCompliance;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpCookie;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpField;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpHeader;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.Syntax;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Attributes;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Index;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.QuotedStringTokenizer;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class HttpCookieUtils {
    public static final String SAME_SITE_DEFAULT_ATTRIBUTE = "com.dataiku.dss.shadelib.org.eclipse.jetty.cookie.sameSiteDefault";
    private static final Index<String> KNOWN_ATTRIBUTES = new Index.Builder().caseSensitive(false).with("Comment").with("Domain").with("Expires").with("HttpOnly").with("Max-Age").with("Path").with("SameSite").with("Secure").with("Partitioned").build();
    private static final String EPOCH_EXPIRES = "Thu, 01 Jan 1970 00:00:00 GMT";

    public static HttpCookie checkSameSite(HttpCookie cookie, Attributes attributes) {
        if (cookie == null || cookie.getSameSite() != null) {
            return cookie;
        }
        HttpCookie.SameSite contextDefault = HttpCookieUtils.getSameSiteDefault(attributes);
        if (contextDefault == null) {
            return cookie;
        }
        return HttpCookie.from(cookie, "SameSite", contextDefault.getAttributeValue());
    }

    public static HttpCookie.SameSite getSameSiteDefault(Attributes contextAttributes) {
        if (contextAttributes == null) {
            return null;
        }
        Object o = contextAttributes.getAttribute(SAME_SITE_DEFAULT_ATTRIBUTE);
        if (o == null) {
            return null;
        }
        if (o instanceof HttpCookie.SameSite) {
            return (HttpCookie.SameSite)((Object)o);
        }
        try {
            HttpCookie.SameSite samesite = Enum.valueOf(HttpCookie.SameSite.class, o.toString().trim().toUpperCase(Locale.ENGLISH));
            contextAttributes.setAttribute(SAME_SITE_DEFAULT_ATTRIBUTE, (Object)samesite);
            return samesite;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getSetCookie(HttpCookie httpCookie, CookieCompliance compliance) {
        if (compliance == null || CookieCompliance.RFC6265_LEGACY.compliesWith(compliance)) {
            return HttpCookieUtils.getRFC6265SetCookie(httpCookie);
        }
        return HttpCookieUtils.getRFC2965SetCookie(httpCookie);
    }

    public static String getRFC2965SetCookie(HttpCookie httpCookie) {
        HttpCookie.SameSite sameSite;
        long maxAge;
        String name = httpCookie.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid cookie name");
        }
        StringBuilder builder = new StringBuilder();
        HttpCookieUtils.quoteIfNeededAndAppend(name, builder);
        builder.append('=');
        String value = httpCookie.getValue();
        HttpCookieUtils.quoteIfNeededAndAppend(value, builder);
        String domain = httpCookie.getDomain();
        boolean hasDomain = domain != null && domain.length() > 0;
        boolean quoteDomain = hasDomain && HttpCookieUtils.isQuoteNeeded(domain);
        String path = httpCookie.getPath();
        boolean hasPath = path != null && path.length() > 0;
        boolean quotePath = hasPath && HttpCookieUtils.isQuoteNeeded(path);
        int version = httpCookie.getVersion();
        String comment = httpCookie.getComment();
        if (version == 0 && (comment != null || HttpCookieUtils.isQuoteNeeded(name) || HttpCookieUtils.isQuoteNeeded(value) || quoteDomain || quotePath || QuotedStringTokenizer.isQuoted(name) || QuotedStringTokenizer.isQuoted(value) || QuotedStringTokenizer.isQuoted(path) || QuotedStringTokenizer.isQuoted(domain))) {
            version = 1;
        }
        if (version == 1) {
            builder.append(";Version=1");
        } else if (version > 1) {
            builder.append(";Version=").append(version);
        }
        if (hasDomain) {
            builder.append(";Domain=");
            if (quoteDomain) {
                HttpField.PARAMETER_TOKENIZER.quote(builder, domain);
            } else {
                builder.append(domain);
            }
        }
        if (hasPath) {
            builder.append(";Path=");
            if (quotePath) {
                HttpField.PARAMETER_TOKENIZER.quote(builder, path);
            } else {
                builder.append(path);
            }
        }
        if ((maxAge = httpCookie.getMaxAge()) >= 0L) {
            builder.append(";Expires=");
            if (maxAge == 0L) {
                builder.append(EPOCH_EXPIRES);
            } else {
                builder.append(HttpCookie.formatExpires(Instant.now().plusSeconds(maxAge)));
            }
            builder.append(";Max-Age=");
            builder.append(maxAge);
        }
        if (httpCookie.isSecure()) {
            builder.append(";Secure");
        }
        if (httpCookie.isHttpOnly()) {
            builder.append(";HttpOnly");
        }
        if (httpCookie.isPartitioned()) {
            builder.append(";Partitioned");
        }
        if ((sameSite = httpCookie.getSameSite()) != null) {
            builder.append(";SameSite=").append(sameSite.getAttributeValue());
        }
        if (comment != null) {
            builder.append(";Comment=");
            HttpCookieUtils.quoteIfNeededAndAppend(comment, builder);
        }
        return builder.toString();
    }

    public static String getRFC6265SetCookie(HttpCookie httpCookie) {
        Map<String, String> attributes;
        String sameSiteAttr;
        long maxAge;
        String domain;
        String name = httpCookie.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Bad cookie name");
        }
        try {
            Syntax.requireValidRFC2616Token(name, "RFC6265 Cookie name");
        }
        catch (IllegalArgumentException e) {
            throw new ComplianceViolationException(CookieCompliance.RFC6265, CookieCompliance.Violation.INVALID_COOKIES, "RFC6265 Cookie name must be a valid RFC2616 Token");
        }
        String value = httpCookie.getValue();
        Syntax.requireValidRFC6265CookieValue(value);
        StringBuilder builder = new StringBuilder();
        builder.append(name).append('=').append(value == null ? "" : value);
        String path = httpCookie.getPath();
        if (path != null && path.length() > 0) {
            builder.append("; Path=").append(path);
        }
        if ((domain = httpCookie.getDomain()) != null && domain.length() > 0) {
            builder.append("; Domain=").append(domain);
        }
        if ((maxAge = httpCookie.getMaxAge()) >= 0L) {
            builder.append("; Expires=");
            if (maxAge == 0L) {
                builder.append(EPOCH_EXPIRES);
            } else {
                builder.append(HttpCookie.formatExpires(Instant.now().plusSeconds(maxAge)));
            }
            builder.append("; Max-Age=");
            builder.append(maxAge);
        }
        if (httpCookie.isSecure()) {
            builder.append("; Secure");
        }
        if (httpCookie.isHttpOnly()) {
            builder.append("; HttpOnly");
        }
        if (httpCookie.isPartitioned()) {
            builder.append("; Partitioned");
        }
        if ((sameSiteAttr = (attributes = httpCookie.getAttributes()).get("SameSite")) != null) {
            builder.append("; SameSite=");
            builder.append(sameSiteAttr);
        } else {
            HttpCookie.SameSite sameSite = httpCookie.getSameSite();
            if (sameSite != null) {
                builder.append("; SameSite=");
                builder.append(sameSite.getAttributeValue());
            }
        }
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            if (KNOWN_ATTRIBUTES.contains(e.getKey())) continue;
            builder.append("; ").append(e.getKey()).append("=");
            builder.append(e.getValue());
        }
        return builder.toString();
    }

    private static boolean isQuoteNeeded(String text) {
        if (text == null || text.length() == 0) {
            return true;
        }
        if (QuotedStringTokenizer.isQuoted(text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ("\",;\\ \t".indexOf(c) >= 0) {
                return true;
            }
            if (c >= ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Illegal character in cookie value");
        }
        return false;
    }

    public static boolean match(String setCookieHeader, String name, String domain, String path) {
        List<java.net.HttpCookie> cookies = java.net.HttpCookie.parse(setCookieHeader);
        if (cookies.size() != 1) {
            return false;
        }
        java.net.HttpCookie cookie = cookies.get(0);
        return HttpCookieUtils.match(cookie.getName(), cookie.getDomain(), cookie.getPath(), name, domain, path);
    }

    public static boolean match(HttpCookie cookie, String name, String domain, String path) {
        if (cookie == null) {
            return false;
        }
        return HttpCookieUtils.match(cookie.getName(), cookie.getDomain(), cookie.getPath(), name, domain, path);
    }

    private static boolean match(String oldName, String oldDomain, String oldPath, String newName, String newDomain, String newPath) {
        if (oldName == null ? newName != null : !oldName.equals(newName)) {
            return false;
        }
        if (oldDomain == null ? newDomain != null : !oldDomain.equalsIgnoreCase(newDomain)) {
            return false;
        }
        if (oldPath == null) {
            return newPath == null;
        }
        return oldPath.equals(newPath);
    }

    private static void quoteIfNeededAndAppend(String text, StringBuilder builder) {
        if (HttpCookieUtils.isQuoteNeeded(text)) {
            HttpField.PARAMETER_TOKENIZER.quote(builder, text);
        } else {
            builder.append(text);
        }
    }

    private HttpCookieUtils() {
    }

    public static class SetCookieHttpField
    extends HttpField {
        private final HttpCookie _cookie;
        private final String _value;

        public SetCookieHttpField(HttpCookie cookie, CookieCompliance compliance) {
            super(HttpHeader.SET_COOKIE, (String)null);
            this._cookie = cookie;
            this._value = HttpCookieUtils.getSetCookie(this._cookie, compliance);
        }

        public HttpCookie getHttpCookie() {
            return this._cookie;
        }

        @Override
        public String getValue() {
            return this._value;
        }
    }
}

