/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpMethod;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpVersion;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ByteBufferPool;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.TunnelSupport;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketComponents;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketConnection;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.WebSocketCoreSession;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.AbstractHandshaker;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.RFC8441Negotiation;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;

public class RFC8441Handshaker
extends AbstractHandshaker {
    @Override
    public boolean isWebSocketUpgradeRequest(Request request) {
        if (!HttpMethod.CONNECT.is(request.getMethod())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded method!=GET {}", (Object)request);
            }
            return false;
        }
        if (!HttpVersion.HTTP_2.is(request.getConnectionMetaData().getProtocol())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("not upgraded HttpVersion!=2 {}", (Object)request);
            }
            return false;
        }
        return super.isWebSocketUpgradeRequest(request);
    }

    @Override
    protected WebSocketNegotiation newNegotiation(Request request, Response response, Callback callback, WebSocketComponents webSocketComponents) {
        return new RFC8441Negotiation(request, response, callback, webSocketComponents);
    }

    @Override
    protected WebSocketConnection createWebSocketConnection(Request request, WebSocketCoreSession coreSession) {
        Connector connector = request.getConnectionMetaData().getConnector();
        ByteBufferPool byteBufferPool = connector.getByteBufferPool();
        TunnelSupport tunnelSupport = request.getTunnelSupport();
        EndPoint endPoint = tunnelSupport.getEndPoint();
        return this.newWebSocketConnection(endPoint, connector.getExecutor(), connector.getScheduler(), byteBufferPool, coreSession);
    }

    @Override
    protected void prepareResponse(Response response, WebSocketNegotiation negotiation) {
        response.setStatus(200);
    }
}

