/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging;

import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.Log;
import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.NoOpLog;
import java.lang.reflect.Constructor;
import java.util.Hashtable;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    public static void setLogImplementation(String classname) throws LinkageError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> logclass = Class.forName(classname);
            Class[] argtypes = new Class[]{"".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable t2) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static Log getInstance(String name) {
        Log log = (Log)logs.get(name);
        if (null == log) {
            log = LogSource.makeNewLogInstance(name);
            logs.put(name, log);
        }
        return log;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name) {
        Log log;
        try {
            Object[] args2 = new Object[]{name};
            log = (Log)logImplctor.newInstance(args2);
        }
        catch (Throwable t2) {
            log = null;
        }
        if (null == log) {
            log = new NoOpLog(name);
        }
        return log;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    static {
        try {
            log4jIsAvailable = null != Class.forName("org.apache.log4j.Logger");
        }
        catch (Throwable t2) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("java.util.logging.Logger") && null != Class.forName("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.Jdk14Logger");
        }
        catch (Throwable t3) {
            jdk14IsAvailable = false;
        }
        String name = null;
        try {
            name = System.getProperty("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.log");
            if (name == null) {
                name = System.getProperty("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.Log");
            }
        }
        catch (Throwable t4) {
            // empty catch block
        }
        if (name != null) {
            try {
                LogSource.setLogImplementation(name);
            }
            catch (Throwable t5) {
                try {
                    LogSource.setLogImplementation("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.NoOpLog");
                }
                catch (Throwable u) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable t6) {
                try {
                    LogSource.setLogImplementation("com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

