/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn;

import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.Log;
import com.dataiku.dss.shadelib.org.mlflow_project.apachecommons.logging.LogFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpRequest;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.HttpResponse;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.config.ConnectionConfig;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.ManagedHttpClientConnection;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.conn.routing.HttpRoute;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.entity.ContentLengthStrategy;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn.DefaultHttpResponseParserFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn.DefaultManagedHttpClientConnection;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.conn.LoggingManagedHttpClientConnection;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.entity.LaxContentLengthStrategy;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.entity.StrictContentLengthStrategy;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.io.DefaultHttpRequestWriterFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.io.HttpMessageParserFactory;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.io.HttpMessageWriterFactory;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ManagedHttpClientConnectionFactory
implements HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> {
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final ManagedHttpClientConnectionFactory INSTANCE = new ManagedHttpClientConnectionFactory();
    private final Log log = LogFactory.getLog(DefaultManagedHttpClientConnection.class);
    private final Log headerlog = LogFactory.getLog("com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.headers");
    private final Log wirelog = LogFactory.getLog("com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.wire");
    private final HttpMessageWriterFactory<HttpRequest> requestWriterFactory;
    private final HttpMessageParserFactory<HttpResponse> responseParserFactory;
    private final ContentLengthStrategy incomingContentStrategy;
    private final ContentLengthStrategy outgoingContentStrategy;

    public ManagedHttpClientConnectionFactory(HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy) {
        this.requestWriterFactory = requestWriterFactory != null ? requestWriterFactory : DefaultHttpRequestWriterFactory.INSTANCE;
        this.responseParserFactory = responseParserFactory != null ? responseParserFactory : DefaultHttpResponseParserFactory.INSTANCE;
        this.incomingContentStrategy = incomingContentStrategy != null ? incomingContentStrategy : LaxContentLengthStrategy.INSTANCE;
        this.outgoingContentStrategy = outgoingContentStrategy != null ? outgoingContentStrategy : StrictContentLengthStrategy.INSTANCE;
    }

    public ManagedHttpClientConnectionFactory(HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        this(requestWriterFactory, responseParserFactory, null, null);
    }

    public ManagedHttpClientConnectionFactory(HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        this(null, responseParserFactory);
    }

    public ManagedHttpClientConnectionFactory() {
        this(null, null);
    }

    @Override
    public ManagedHttpClientConnection create(HttpRoute route, ConnectionConfig config) {
        CodingErrorAction unmappableInputAction;
        ConnectionConfig cconfig = config != null ? config : ConnectionConfig.DEFAULT;
        CharsetDecoder chardecoder = null;
        CharsetEncoder charencoder = null;
        Charset charset = cconfig.getCharset();
        CodingErrorAction malformedInputAction = cconfig.getMalformedInputAction() != null ? cconfig.getMalformedInputAction() : CodingErrorAction.REPORT;
        CodingErrorAction codingErrorAction = unmappableInputAction = cconfig.getUnmappableInputAction() != null ? cconfig.getUnmappableInputAction() : CodingErrorAction.REPORT;
        if (charset != null) {
            chardecoder = charset.newDecoder();
            chardecoder.onMalformedInput(malformedInputAction);
            chardecoder.onUnmappableCharacter(unmappableInputAction);
            charencoder = charset.newEncoder();
            charencoder.onMalformedInput(malformedInputAction);
            charencoder.onUnmappableCharacter(unmappableInputAction);
        }
        String id = "http-outgoing-" + Long.toString(COUNTER.getAndIncrement());
        return new LoggingManagedHttpClientConnection(id, this.log, this.headerlog, this.wirelog, cconfig.getBufferSize(), cconfig.getFragmentSizeHint(), chardecoder, charencoder, cconfig.getMessageConstraints(), this.incomingContentStrategy, this.outgoingContentStrategy, this.requestWriterFactory, this.responseParserFactory);
    }
}

