/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelib.reactor.core.publisher.FluxConcatMap;
import com.dataiku.dss.shadelib.reactor.core.publisher.FluxFlatMap;
import com.dataiku.dss.shadelib.reactor.core.publisher.InternalFluxOperator;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelib.reactor.util.annotation.Nullable;
import com.dataiku.dss.shadelib.reactor.util.context.Context;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;

final class FluxConcatMapNoPrefetch<T, R>
extends InternalFluxOperator<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final FluxConcatMap.ErrorMode errorMode;

    FluxConcatMapNoPrefetch(Flux<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, FluxConcatMap.ErrorMode errorMode) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.errorMode = errorMode;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super R> actual) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, actual, this.mapper, false, true)) {
            return null;
        }
        return new FluxConcatMapNoPrefetchSubscriber<T, R>(actual, this.mapper, this.errorMode);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public int getPrefetch() {
        return 0;
    }

    static final class FluxConcatMapNoPrefetchSubscriber<T, R>
    implements FluxConcatMap.FluxConcatMapSupport<T, R> {
        volatile State state;
        static final AtomicReferenceFieldUpdater<FluxConcatMapNoPrefetchSubscriber, State> STATE = AtomicReferenceFieldUpdater.newUpdater(FluxConcatMapNoPrefetchSubscriber.class, State.class, "state");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<FluxConcatMapNoPrefetchSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(FluxConcatMapNoPrefetchSubscriber.class, Throwable.class, "error");
        final CoreSubscriber<? super R> actual;
        final FluxConcatMap.ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final FluxConcatMap.ErrorMode errorMode;
        Subscription upstream;

        FluxConcatMapNoPrefetchSubscriber(CoreSubscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, FluxConcatMap.ErrorMode errorMode) {
            this.actual = actual;
            this.mapper = mapper;
            this.errorMode = errorMode;
            this.inner = new FluxConcatMap.ConcatMapInner(this);
            STATE.lazySet(this, State.INITIAL);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.upstream;
            }
            if (key == Scannable.Attr.TERMINATED) {
                return this.state == State.TERMINATED;
            }
            if (key == Scannable.Attr.CANCELLED) {
                return this.state == State.CANCELLED;
            }
            if (key == Scannable.Attr.DELAY_ERROR) {
                return this.errorMode != FluxConcatMap.ErrorMode.IMMEDIATE;
            }
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return FluxConcatMap.FluxConcatMapSupport.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super R> actual() {
            return this.actual;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            block10: {
                if (!STATE.compareAndSet(this, State.REQUESTED, State.ACTIVE)) {
                    switch (this.state) {
                        case CANCELLED: {
                            Operators.onDiscard(t2, this.currentContext());
                            break;
                        }
                        case TERMINATED: {
                            Operators.onNextDropped(t2, this.currentContext());
                        }
                    }
                    return;
                }
                try {
                    Publisher<R> p = this.mapper.apply(t2);
                    Objects.requireNonNull(p, "The mapper returned a null Publisher");
                    if (p instanceof Callable) {
                        Callable callable = (Callable)((Object)p);
                        Object result = callable.call();
                        if (result == null) {
                            this.innerComplete();
                            return;
                        }
                        if (this.inner.isUnbounded()) {
                            this.actual.onNext(result);
                            this.innerComplete();
                            return;
                        }
                        this.inner.set(new FluxConcatMap.WeakScalarSubscription(result, this.inner));
                        return;
                    }
                    p.subscribe(this.inner);
                }
                catch (Throwable e) {
                    Context ctx = this.actual.currentContext();
                    Operators.onDiscard(t2, ctx);
                    if (this.maybeOnError(Operators.onNextError(t2, e, ctx), ctx, this.upstream)) break block10;
                    this.innerComplete();
                }
            }
        }

        @Override
        public void onError(Throwable t2) {
            Context ctx = this.currentContext();
            if (!this.maybeOnError(t2, ctx, this.inner)) {
                this.onComplete();
            }
        }

        @Override
        public void onComplete() {
            State previousState = this.state;
            while (true) {
                switch (previousState) {
                    case INITIAL: 
                    case REQUESTED: {
                        if (!STATE.compareAndSet(this, previousState, State.TERMINATED)) break;
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.actual.onError(ex);
                            return;
                        }
                        this.actual.onComplete();
                        return;
                    }
                    case ACTIVE: {
                        if (!STATE.compareAndSet(this, previousState, State.LAST_ACTIVE)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                previousState = this.state;
            }
        }

        @Override
        public synchronized void innerNext(R value) {
            switch (this.state) {
                case ACTIVE: 
                case LAST_ACTIVE: {
                    this.actual.onNext(value);
                    break;
                }
                default: {
                    Operators.onDiscard(value, this.currentContext());
                }
            }
        }

        @Override
        public void innerComplete() {
            State previousState = this.state;
            while (true) {
                switch (previousState) {
                    case ACTIVE: {
                        if (!STATE.compareAndSet(this, previousState, State.REQUESTED)) break;
                        this.upstream.request(1L);
                        return;
                    }
                    case LAST_ACTIVE: {
                        if (!STATE.compareAndSet(this, previousState, State.TERMINATED)) break;
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.actual.onError(ex);
                            return;
                        }
                        this.actual.onComplete();
                        return;
                    }
                    default: {
                        return;
                    }
                }
                previousState = this.state;
            }
        }

        @Override
        public void innerError(Throwable e) {
            Context ctx = this.currentContext();
            if (!this.maybeOnError(Operators.onNextInnerError(e, ctx, null), ctx, this.upstream)) {
                this.innerComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean maybeOnError(@Nullable Throwable e, Context ctx, Subscription subscriptionToCancel) {
            if (e == null) {
                return false;
            }
            if (!ERROR.compareAndSet(this, null, e)) {
                Operators.onErrorDropped(e, ctx);
            }
            if (this.errorMode == FluxConcatMap.ErrorMode.END) {
                return false;
            }
            State previousState = this.state;
            while (true) {
                switch (previousState) {
                    case CANCELLED: 
                    case TERMINATED: {
                        return true;
                    }
                }
                if (STATE.compareAndSet(this, previousState, State.TERMINATED)) {
                    subscriptionToCancel.cancel();
                    FluxConcatMapNoPrefetchSubscriber fluxConcatMapNoPrefetchSubscriber = this;
                    synchronized (fluxConcatMapNoPrefetchSubscriber) {
                        this.actual.onError(this.error);
                    }
                    return true;
                }
                previousState = this.state;
            }
        }

        @Override
        public void request(long n) {
            if (STATE.compareAndSet(this, State.INITIAL, State.REQUESTED)) {
                this.upstream.request(1L);
            }
            this.inner.request(n);
        }

        @Override
        public void cancel() {
            switch (STATE.getAndSet(this, State.CANCELLED)) {
                case CANCELLED: {
                    break;
                }
                case TERMINATED: {
                    this.inner.cancel();
                    break;
                }
                default: {
                    this.inner.cancel();
                    this.upstream.cancel();
                }
            }
        }

        static enum State {
            INITIAL,
            REQUESTED,
            ACTIVE,
            LAST_ACTIVE,
            TERMINATED,
            CANCELLED;

        }
    }
}

