/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.health;

import com.codahale.metrics.health.HealthCheck;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.endpoints.predictcommon.PredictionEndpointHandlerBase;
import com.dataiku.lambda.model.api.PredictionResponse;
import com.dataiku.lambda.model.api.SinglePredictionQuery;
import com.dataiku.lambda.services.ServiceManager;
import com.dataiku.lambda.services.ServicesService;

public class PredictionEndpointHealthCheck
extends HealthCheck {
    private String serviceId;
    private String endpointId;
    private SinglePredictionQuery query;

    public PredictionEndpointHealthCheck(String serviceId, String endpointId, SinglePredictionQuery query) {
        this.serviceId = serviceId;
        this.endpointId = endpointId;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HealthCheck.Result check() throws Exception {
        ServicesService serviceService = (ServicesService)SpringUtils.getBean(ServicesService.class);
        ServiceManager manager = serviceService.getServiceManagerCheck(this.serviceId);
        ServiceManager.RefcountedEndpoint re = manager.acquireEndpoint(this.endpointId, this.query.dispatch);
        try {
            PredictionEndpointHandlerBase peh = (PredictionEndpointHandlerBase)re.getHandler();
            PredictionResponse resp = peh.predict(System.nanoTime(), re, this.query, null, null);
            System.err.println("*********************");
            System.err.println(JSON.json((Object)resp));
            System.err.println("*********************");
            String msg = JSON.json((Object)resp).toString();
            HealthCheck.Result result = HealthCheck.Result.healthy((String)msg);
            return result;
        }
        finally {
            manager.releaseEndpoint(re);
        }
    }
}

