/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomaton;

import com.BoxOfC.LevenshteinAutomaton.AugBitSet;
import com.BoxOfC.LevenshteinAutomaton.Position;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class State {
    private final Position[] memberPositionArray;

    public State(Position[] memberPositionArray) {
        this.memberPositionArray = memberPositionArray;
    }

    public State(State s, Position p) {
        int newMemberPositionArrayLength = s.memberPositionArray.length + 1;
        this.memberPositionArray = Arrays.copyOf(s.memberPositionArray, newMemberPositionArrayLength);
        this.memberPositionArray[newMemberPositionArrayLength - 1] = p;
        Arrays.sort(this.memberPositionArray);
    }

    public State(Collection<State> stateCollection, int maxEditDistance) {
        HashSet<Position> prospectiveMemberPositionCollection = new HashSet<Position>();
        for (State state : stateCollection) {
            prospectiveMemberPositionCollection.addAll(Arrays.asList(state.memberPositionArray));
        }
        Iterator it1 = prospectiveMemberPositionCollection.iterator();
        block1: while (it1.hasNext()) {
            Position position1 = (Position)it1.next();
            for (Position position2 : prospectiveMemberPositionCollection) {
                if (!position2.subsumes(position1, maxEditDistance)) continue;
                it1.remove();
                continue block1;
            }
        }
        this.memberPositionArray = prospectiveMemberPositionCollection.toArray(new Position[prospectiveMemberPositionCollection.size()]);
        Arrays.sort(this.memberPositionArray);
    }

    public int getMinimalBoundary() {
        return this.memberPositionArray[0].getI();
    }

    public Position[] getMemberPositions() {
        return this.memberPositionArray;
    }

    public AugBitSet getRelevantSubwordCharacteristicVector(int maxEditDistance, String automatonString, char letter) {
        int minimalPositionBoundary = this.memberPositionArray[0].getI();
        int relevantSubwordSize = Math.min(2 * maxEditDistance + 1, automatonString.length() - minimalPositionBoundary);
        String relevantSubword = automatonString.substring(minimalPositionBoundary, minimalPositionBoundary + relevantSubwordSize);
        AugBitSet relevantSubwordCharacteristicVector = new AugBitSet(relevantSubwordSize);
        for (int i = 0; i < relevantSubwordSize; ++i) {
            if (relevantSubword.charAt(i) != letter) continue;
            relevantSubwordCharacteristicVector.set(i);
        }
        return relevantSubwordCharacteristicVector;
    }

    public State transition(int maxEditDistance, AugBitSet relevantSubwordCharacteristicVector) {
        HashSet<State> newStateHashSet = new HashSet<State>();
        int boundaryOffset = this.memberPositionArray[0].getI();
        for (Position p : this.memberPositionArray) {
            State transitionState = p.transition(maxEditDistance, p.getI() - boundaryOffset, relevantSubwordCharacteristicVector);
            if (transitionState == null) continue;
            newStateHashSet.add(transitionState);
        }
        return newStateHashSet.isEmpty() ? null : new State(newStateHashSet, maxEditDistance);
    }

    public State transition(int maxEditDistance, String automatonString, char letter) {
        return this.transition(maxEditDistance, this.getRelevantSubwordCharacteristicVector(maxEditDistance, automatonString, letter));
    }

    public String toString() {
        String returnString = this.memberPositionArray[0].toString();
        int memberPositionCount = this.memberPositionArray.length;
        for (int i = 1; i < memberPositionCount; ++i) {
            returnString = returnString + " " + this.memberPositionArray[i].toString();
        }
        return returnString;
    }

    public static boolean canBeState(State state, Position prospectivePosition, int maxEditDistance) {
        for (Position currentMemberPosition : state.memberPositionArray) {
            if (!currentMemberPosition.subsumes(prospectivePosition, maxEditDistance)) continue;
            return false;
        }
        return true;
    }

    public static int getMinimumBoundariesDifference(State state1, State state2) {
        return Math.abs(state1.memberPositionArray[0].getI() - state2.memberPositionArray[0].getI());
    }
}

