/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.common.rpc;

import com.dataiku.common.stereotype.RoutinelyUsedInExtensionCode;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.ClientProtocolException;
import com.dataiku.dss.shadelib.org.apache.http.client.ResponseHandler;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.entity.ContentType;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.HttpMultipartMode;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.MultipartEntityBuilder;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ByteArrayBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.ContentBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.FileBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.InputStreamBody;
import com.dataiku.dss.shadelib.org.apache.http.entity.mime.content.StringBody;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@RoutinelyUsedInExtensionCode
public class ExternalJSONAPIClient
implements AutoCloseable {
    protected String baseURI;
    private final Map<String, String> additionalHeaders = new HashMap<String, String>();
    private final CloseableHttpClient httpClient;
    private final ResponseRetryStrategy responseRetryStrategy;
    @Deprecated(since="14.2.0", forRemoval=true)
    public boolean allowChunkedEncoding = false;
    public boolean forceContentLength;
    private final CloseCallback closeCallback;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.api.client");

    public ExternalJSONAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings) {
        this(baseURI, serverCertPEM, trustAllSSLCertificates, proxySettings, new NoOpResponseRetryStrategy(), null);
    }

    public ExternalJSONAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings, @Nullable Consumer<HttpClientBuilder> customizeBuilderCallback) {
        this(baseURI, serverCertPEM, trustAllSSLCertificates, proxySettings, new NoOpResponseRetryStrategy(), customizeBuilderCallback);
    }

    public ExternalJSONAPIClient(String baseURI, String serverCertPEM, boolean trustAllSSLCertificates, ProxySettings proxySettings, ResponseRetryStrategy responseRetryStrategy, @Nullable Consumer<HttpClientBuilder> customizeBuilderCallback) {
        this.baseURI = baseURI;
        CustomHttpClientBuilder builder = new CustomHttpClientBuilder();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings(proxySettings, builder);
        PoolingHttpClientConnectionManager cm = HTTPClientUtils.buildPoolingHttpClientConnectionManager(serverCertPEM, trustAllSSLCertificates);
        cm.setMaxTotal(10);
        cm.setDefaultMaxPerRoute(10);
        RequestConfig config = RequestConfig.custom().setSocketTimeout(this.getSocketTimeout()).setConnectTimeout(this.getConnectTimeout()).build();
        builder.setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(config);
        if (customizeBuilderCallback != null) {
            customizeBuilderCallback.accept(builder);
        }
        this.closeCallback = builder.getCloseCallback();
        this.httpClient = builder.build();
        this.responseRetryStrategy = responseRetryStrategy;
        this.forceContentLength = this.shouldForceContentLength();
    }

    private boolean shouldForceContentLength() {
        boolean forceContentLength = false;
        if (DKUApp.getParams().getBoolParam("dku.externalJsonAPIClient.allowChunkedEncoding", false)) {
            logger.warn((Object)"dku.externalJsonAPIClient.allowChunkedEncoding dip property is deprecated, use dku.connection.llm.forceContentLength connection property instead.");
            forceContentLength = true;
        }
        return forceContentLength;
    }

    @Override
    public void close() {
        try {
            if (this.closeCallback != null) {
                this.closeCallback.close();
            }
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to close API client", (Throwable)e);
        }
    }

    protected HttpGet newGet(String path) {
        HttpGet get = new HttpGet(this.buildUri(path));
        this.setAdditionalHeadersInRequest((HttpRequestBase)get);
        return get;
    }

    protected HttpPost newPost(String path) throws Exception {
        HttpPost post = new HttpPost(this.buildUri(path));
        this.setAdditionalHeadersInRequest((HttpRequestBase)post);
        return post;
    }

    protected HttpPut newPut(String path) {
        HttpPut put = new HttpPut(this.buildUri(path));
        this.setAdditionalHeadersInRequest((HttpRequestBase)put);
        return put;
    }

    protected HttpDelete newDelete(String path) {
        HttpDelete del = new HttpDelete(this.buildUri(path));
        this.setAdditionalHeadersInRequest((HttpRequestBase)del);
        return del;
    }

    private String buildUri(String path) {
        return this.baseURI + "/" + path;
    }

    protected void setAdditionalHeadersInRequest(HttpRequestBase req) {
        for (Map.Entry<String, String> e : this.additionalHeaders.entrySet()) {
            req.addHeader(e.getKey(), e.getValue());
        }
    }

    public void addHeader(String key, String value) {
        this.additionalHeaders.put(key, value);
    }

    protected int getConnectTimeout() {
        return 0;
    }

    protected int getSocketTimeout() {
        return 0;
    }

    protected HttpPost newJSONPost(String method, Object arg) throws Exception {
        HttpPost post = this.newPost(method);
        post.setHeader("Content-Type", "application/json");
        post.setEntity(this.getHttpEntity(arg));
        return post;
    }

    protected HttpPost newJSONPost(String method, int timeout, Object arg) throws Exception {
        HttpPost post = this.newPost(method);
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(this.getHttpEntity(arg));
        return post;
    }

    @Nonnull
    private HttpEntity getHttpEntity(Object arg) {
        HttpEntity entity = this.allowChunkedEncoding || this.forceContentLength ? JSON.toStringEntity((Object)arg) : JSON.toHttpEntity((Object)arg);
        return entity;
    }

    protected HttpPut newJSONPut(String method, Object arg) throws Exception {
        HttpPut put = this.newPut(method);
        put.setEntity(this.getHttpEntity(arg));
        return put;
    }

    protected HttpPut newJSONPut(String method, int timeout, Object arg) throws Exception {
        HttpPut post = this.newPut(method);
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(this.getHttpEntity(arg));
        return post;
    }

    protected HttpPost newAnyPost(String method, HttpEntity entity) throws Exception {
        HttpPost post = this.newPost(method);
        post.setEntity(entity);
        return post;
    }

    public HttpPost newAnyPost(String method, int timeout, HttpEntity entity) throws Exception {
        HttpPost post = this.newPost(method);
        HttpConnectionParams.setConnectionTimeout((HttpParams)post.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)post.getParams(), (int)timeout);
        post.setEntity(entity);
        return post;
    }

    public <T> T getToJSON(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpGet get;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            get = this.newGet(method + (String)(args.length > 0 ? "?" + URLEncodedUtils.format(nvps, (Charset)StandardCharsets.UTF_8) : ""));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        logger.info((Object)("Sending get to " + String.valueOf(get.getURI())));
        return this.execute((HttpUriRequest)get, response -> this.handleJSONResp(response, ofClazz));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postObjectToJSON(String method, Class<T> ofClazz, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            T t = this.execute((HttpUriRequest)pm, response -> this.handleJSONResp(response, ofClazz));
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T putObjectToJSON(String method, Class<T> ofClazz, Object arg) throws IOException {
        HttpPut pm;
        try {
            pm = this.newJSONPut(method, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            T t = this.execute((HttpUriRequest)pm, response -> this.handleJSONResp(response, ofClazz));
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T> T postObjectToJSON(String method, int timeout, Class<T> ofClazz, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, timeout, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.execute((HttpUriRequest)pm, response -> this.handleJSONResp(response, ofClazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<T> responseHandler) throws IOException {
        int executionCount = 1;
        while (true) {
            CloseableHttpResponse resp = this.httpClient.execute(httpUriRequest);
            try {
                Object object = responseHandler.handleResponse((HttpResponse)resp);
                return (T)object;
            }
            catch (IOException e) {
                if (!this.responseRetryStrategy.canRetry(e, (HttpResponse)resp, executionCount)) {
                    throw e;
                }
            }
            finally {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
            ++executionCount;
        }
    }

    protected EntityAndRequest executeStream(HttpRequestBase httpRequest) throws IOException {
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)httpRequest);
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return null;
        }
        if (code == 200 || code == 201) {
            return new EntityAndRequest(resp.getEntity(), httpRequest);
        }
        try {
            String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            throw new JSONAPIClientException(code, s);
        }
        catch (Throwable throwable) {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            throw throwable;
        }
    }

    public <T> T postFormToJSON(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.execute((HttpUriRequest)post, response -> this.handleJSONResp(response, ofClazz));
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, File file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new FileBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, InputStream file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new InputStreamBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    public <T> T postFormAndFileToJSON(String method, Class<T> ofClazz, byte[] file, String fileName, Object ... args) throws IOException {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file", (ContentBody)new ByteArrayBody(file, ContentType.DEFAULT_BINARY, fileName));
        return this.postFormAndMultipartToJSON(method, ofClazz, builder, args);
    }

    private <T> T postFormAndMultipartToJSON(String method, Class<T> ofClazz, MultipartEntityBuilder builder, Object ... args) throws IOException, ClientProtocolException {
        HttpPost post;
        logger.info((Object)"postFormAndMultiPart");
        logger.info((Object)("ARGS " + StringUtils.join((Object[])args)));
        for (int i = 0; i < args.length; i += 2) {
            builder.addPart((String)args[i], (ContentBody)new StringBody(String.valueOf(args[i + 1]), ContentType.MULTIPART_FORM_DATA));
        }
        try {
            HttpEntity entity = builder.build();
            post = this.newAnyPost(method, entity);
            post.setHeader(entity.getContentType());
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.execute((HttpUriRequest)post, response -> this.handleJSONResp(response, ofClazz));
    }

    public <T> T postFormToJSON(String method, int timeout, Class<T> ofClazz, Object ... args) throws IOException {
        HttpPost post;
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        for (int i = 0; i < args.length; i += 2) {
            nvps.add(new BasicNameValuePair((String)args[i], String.valueOf(args[i + 1])));
        }
        try {
            post = this.newAnyPost(method, timeout, (HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.execute((HttpUriRequest)post, response -> this.handleJSONResp(response, ofClazz));
    }

    public <T> T executeToJSON(HttpUriRequest method, Class<T> ofClazz) throws IOException {
        return this.execute(method, response -> this.handleJSONResp(response, ofClazz));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T postAnyToJSON(String method, int timeout, Class<T> ofClazz, HttpEntity entity) throws IOException {
        HttpPost pm;
        try {
            pm = this.newAnyPost(method, timeout, entity);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        try (FutureAborter.AutoCloseableAbortHook aborter = FutureAborter.pushAutoCloseableHook((Runnable)new Runnable(){

            @Override
            public void run() {
                pm.abort();
            }
        });){
            T t = this.execute((HttpUriRequest)pm, response -> this.handleJSONResp(response, ofClazz));
            return t;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public EntityAndRequest postJSONToStreamAndRequest(String method, int timeout, Object arg) throws IOException {
        HttpPost pm;
        try {
            pm = this.newJSONPost(method, timeout, arg);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.executeStream((HttpRequestBase)pm);
    }

    public EntityAndRequest getToStreamAndRequest(String method, int timeout) throws IOException {
        HttpGet pm;
        try {
            pm = this.newGet(method);
            HttpConnectionParams.setConnectionTimeout((HttpParams)pm.getParams(), (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)pm.getParams(), (int)timeout);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.executeStream((HttpRequestBase)pm);
    }

    public <T> T delete(String method, Class<T> ofClazz, Object ... args) throws IOException {
        HttpDelete pm;
        URIBuilder builder = new URIBuilder().setPath(method);
        for (int i = 0; i < args.length; i += 2) {
            builder.addParameter((String)args[i], String.valueOf(args[i + 1]));
        }
        String pathAndQuery = builder.toString();
        logger.info((Object)("DELETE PATH " + pathAndQuery));
        try {
            pm = this.newDelete(pathAndQuery);
        }
        catch (Exception e) {
            throw new IOException("Failed to create request", e);
        }
        return this.execute((HttpUriRequest)pm, response -> this.handleJSONResp(response, ofClazz));
    }

    private <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            return null;
        }
        if (code == 200 || code == 201) {
            return (T)JSON.parse((InputStream)resp.getEntity().getContent(), ofClazz);
        }
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        throw new JSONAPIClientException(code, s);
    }

    public static class NoOpResponseRetryStrategy
    implements ResponseRetryStrategy {
        @Override
        public boolean canRetry(IOException e, HttpResponse resp, int executionCount) {
            return false;
        }
    }

    public static interface ResponseRetryStrategy {
        public boolean canRetry(IOException var1, HttpResponse var2, int var3);
    }

    public class CustomHttpClientBuilder
    extends HttpClientBuilder {
        private final CloseCallback closeCallback = new CloseCallback();

        public CloseCallback getCloseCallback() {
            return this.closeCallback;
        }
    }

    public static class CloseCallback {
        private volatile boolean closed = false;

        public boolean isClosed() {
            return this.closed;
        }

        public void close() {
            this.closed = true;
        }
    }

    public static class EntityAndRequest {
        public HttpRequestBase request;
        public HttpEntity entity;

        EntityAndRequest(HttpEntity entity, HttpRequestBase request) {
            this.entity = entity;
            this.request = request;
        }
    }

    public static class JSONAPIClientException
    extends IOException {
        private static final long serialVersionUID = 1L;
        public final int httpCode;
        public final String responseText;

        public JSONAPIClientException(int httpCode, String responseText) {
            super("HTTP code: " + httpCode + ", response: " + responseText);
            this.httpCode = httpCode;
            this.responseText = responseText;
        }
    }
}

