/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.spooling;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.spooling.DataAttributes;
import io.trino.jdbc.$internal.client.spooling.Segment;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SpooledSegment
extends Segment {
    private final URI dataUri;
    private final Map<String, List<String>> headers;

    @.JsonCreator
    public SpooledSegment(@.JsonProperty(value="uri") URI dataUri, @.JsonProperty(value="metadata") Map<String, Object> metadata, @.JsonProperty(value="headers") Map<String, List<String>> headers) {
        this(dataUri, new DataAttributes(metadata), headers);
    }

    SpooledSegment(URI dataUri, DataAttributes metadata, Map<String, List<String>> headers) {
        super(metadata);
        this.dataUri = Objects.requireNonNull(dataUri, "dataUri is null");
        this.headers = MoreObjects.firstNonNull(headers, ImmutableMap.of());
    }

    @.JsonProperty(value="uri")
    public URI getDataUri() {
        return this.dataUri;
    }

    @.JsonInclude(value=.JsonInclude.Include.NON_EMPTY)
    @.JsonProperty(value="headers")
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String toString() {
        return String.format("SpooledSegment{offset=%d, rows=%d, size=%d, headers=%s}", this.getOffset(), this.getRowsCount(), this.getSegmentSize(), this.headers.keySet());
    }
}

