/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.plugins.IPluginsRegistryService;
import com.dataiku.gh.security.auth.UIAuthService;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class PluginsController
extends DIPInternalControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;

    @AuditedCall(value={"msgType", "plugin-action-run", "pluginId", "${pluginId}", "actionId", "${actionId}", "artifactId", "${artifactId}"})
    @RequestMapping(value={"/api/plugins/{pluginId}/actions/{actionId}/run"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.PLUGIN_ACTION_RUN)
    public void runAction(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId, @PathVariable String actionId, @RequestParam String artifactId, @RequestParam(required=false) JsonObject params) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        PluginsController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsRegistryService.runAction(authCtx, pluginId, actionId, artifactId, params));
    }
}

