/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.ui.UIGetUploadedFileDescsResult;
import com.dataiku.gh.core.models.uploaded_files.UploadedFile;
import com.dataiku.gh.core.models.uploaded_files.UploadedFileDesc;
import com.dataiku.gh.core.services.uploaded_files.IUploadedFilesService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartResolver;

@Controller
public class UploadedFilesController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private MultipartResolver resolver;
    @Autowired
    private IUploadedFilesService uploadedFilesService;

    @AuditedCall(value={"msgType", "uploaded-file-get-desc", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/api/uploaded-files/get-desc"}, method={RequestMethod.GET})
    public void getFileDesc(HttpServletRequest req, HttpServletResponse resp, @RequestParam String uploadedFileId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        UploadedFilesController.writeJSON((HttpServletResponse)resp, (Object)this.uploadedFilesService.getUploadedFileDesc(authCtx, uploadedFileId));
    }

    @AuditedCall(value={"msgType", "uploaded-file-get", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/api/uploaded-files/get"}, method={RequestMethod.GET})
    public void getFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String uploadedFileId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUserNoXSRF(req);
        }
        UploadedFile file = this.uploadedFilesService.getUploadedFile(authCtx, uploadedFileId);
        this.writeStream(resp, file.data, file.desc.type, file.desc.name);
    }

    @AuditedCall(value={"msgType", "uploaded-files-list-desc", "uploadedFileIds", "${uploadedFileIds}"})
    @RequestMapping(value={"/api/uploaded-files/list-desc-by-ids"}, method={RequestMethod.POST})
    @ResponseBody
    public UIGetUploadedFileDescsResult listFilesDesc(HttpServletRequest req, @RequestParam List<String> uploadedFileIds) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return UIGetUploadedFileDescsResult.build(this.uploadedFilesService.getUploadedFileDescsOrExceptions(authCtx, uploadedFileIds));
    }

    @AuditInline
    @RequestMapping(value={"/api/uploaded-files/upload"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.UPLOADED_FILE_UPLOAD)
    public void uploadFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam MultipartFile file) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            UploadedFileDesc uploadedFileDesc = this.uploadedFilesService.uploadFile(authCtx, file.getOriginalFilename(), file.getInputStream(), file.getSize());
            this.auditTrailService.generic("uploaded-file-upload").with("uploadedFileId", uploadedFileDesc.id).emit();
            UploadedFilesController.writeJSON((HttpServletResponse)resp, (Object)uploadedFileDesc);
        }
        catch (Exception e) {
            this.auditTrailService.failure("uploaded-file-upload", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "uploaded-file-delete", "uploadedFileId", "${uploadedFileId}"})
    @RequestMapping(value={"/api/uploaded-files/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.UPLOADED_FILE_DELETE)
    public void deleteFile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String uploadedFileId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.uploadedFilesService.deleteUploadedFile(authCtx, uploadedFileId);
        UploadedFilesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

