/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.roles.permissions;

import com.dataiku.gh.core.visitors.IBlueprintPermissionsVisitor;
import java.util.Objects;

public class ArtifactPermissionsItem {
    public boolean read;
    public boolean write;
    public boolean delete;
    public boolean create;
    public boolean admin;

    public boolean hasReadPermission() {
        return this.read || this.write || this.delete || this.admin;
    }

    public boolean hasWritePermission() {
        return this.write || this.admin;
    }

    public boolean hasDeletePermission() {
        return this.delete || this.admin;
    }

    public boolean hasCreatePermission() {
        return this.create || this.admin;
    }

    public boolean hasAdminPermission() {
        return this.admin;
    }

    public boolean hasAllPermissions() {
        return this.hasAdminPermission();
    }

    public boolean hasAnyPermissions() {
        return this.hasReadPermission() || this.hasWritePermission() || this.hasDeletePermission() || this.hasCreatePermission() || this.hasAdminPermission();
    }

    public boolean hasNoPermissions() {
        return !this.hasAnyPermissions();
    }

    public ArtifactPermissionsItem mergeWith(ArtifactPermissionsItem artifactPermissionsItem) {
        this.read = this.hasReadPermission() || artifactPermissionsItem.hasReadPermission();
        this.write = this.hasWritePermission() || artifactPermissionsItem.hasWritePermission();
        this.delete = this.hasDeletePermission() || artifactPermissionsItem.hasDeletePermission();
        this.create = this.hasCreatePermission() || artifactPermissionsItem.hasCreatePermission();
        this.admin = this.hasAdminPermission() || artifactPermissionsItem.hasAdminPermission();
        return this;
    }

    public void accept(IBlueprintPermissionsVisitor blueprintPermissionsVisitor) {
        blueprintPermissionsVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactPermissionsItem)) {
            return false;
        }
        ArtifactPermissionsItem api = (ArtifactPermissionsItem)o;
        return Objects.equals(this.read, api.read) && Objects.equals(this.write, api.write) && Objects.equals(this.delete, api.delete) && Objects.equals(this.create, api.create) && Objects.equals(this.admin, api.admin);
    }

    public int hashCode() {
        return Objects.hash(this.read, this.write, this.delete, this.create, this.admin);
    }

    public static ArtifactPermissionsItem createWithNoPermissions() {
        return ArtifactPermissionsItem.build(false, false, false, false, false);
    }

    public static ArtifactPermissionsItem createWithAllPermissions() {
        return ArtifactPermissionsItem.build(true, true, true, true, true);
    }

    public static ArtifactPermissionsItem build(boolean read, boolean write, boolean delete, boolean create, boolean admin) {
        ArtifactPermissionsItem artifactPermissionsItem = new ArtifactPermissionsItem();
        artifactPermissionsItem.read = read;
        artifactPermissionsItem.write = write;
        artifactPermissionsItem.delete = delete;
        artifactPermissionsItem.create = create;
        artifactPermissionsItem.admin = admin;
        return artifactPermissionsItem;
    }
}

