/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.roles.permissions;

import com.dataiku.gh.core.models.roles.permissions.ArtifactPermissionsItem;
import com.dataiku.gh.core.models.roles.permissions.FieldPermissionsItem;
import com.dataiku.gh.core.visitors.IBlueprintPermissionsVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class PermissionsItem {
    public ArtifactPermissionsItem artifactPermissionsItem = ArtifactPermissionsItem.createWithNoPermissions();
    public Map<String, FieldPermissionsItem> fieldPermissionsItems = new HashMap<String, FieldPermissionsItem>();
    public boolean fieldsDefaultRead = false;
    public boolean fieldsDefaultWrite = false;

    public void accept(IBlueprintPermissionsVisitor blueprintPermissionsVisitor) {
        this.artifactPermissionsItem.accept(blueprintPermissionsVisitor);
        this.fieldPermissionsItems.forEach((fieldId, fieldPermissionsItem) -> fieldPermissionsItem.accept(blueprintPermissionsVisitor, (String)fieldId));
        blueprintPermissionsVisitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionsItem that = (PermissionsItem)o;
        return this.fieldsDefaultRead == that.fieldsDefaultRead && this.fieldsDefaultWrite == that.fieldsDefaultWrite && Objects.equals(this.artifactPermissionsItem, that.artifactPermissionsItem) && Objects.equals(this.fieldPermissionsItems, that.fieldPermissionsItems);
    }

    public int hashCode() {
        return Objects.hash(this.artifactPermissionsItem, this.fieldPermissionsItems, this.fieldsDefaultRead, this.fieldsDefaultWrite);
    }

    public static PermissionsItem build(ArtifactPermissionsItem artifactPermissionsItem, boolean fieldsDefaultRead, boolean fieldsDefaultWrite) {
        PermissionsItem permissionsItem = new PermissionsItem();
        permissionsItem.artifactPermissionsItem = artifactPermissionsItem;
        permissionsItem.fieldsDefaultRead = fieldsDefaultRead;
        permissionsItem.fieldsDefaultWrite = fieldsDefaultWrite;
        return permissionsItem;
    }
}

