/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.search;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactFilterFieldConditionType;
import com.dataiku.gh.core.models.search.ArtifactSearchSort;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.search.FieldLogic;
import com.dataiku.gh.core.models.search.SubqueryArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.search.field_condition_types.DateConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.NumberConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.TextConditionType;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QArtifactWorkflowCurrentStatus;
import com.dataiku.gh.core.storage.sql.model.QPartialEnrichedArtifacts;
import com.dataiku.gh.core.storage.sql.model.QSignoffsWithVisibility;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.Either;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.math.DoubleMath;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.JoinFlag;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.DateTemplate;
import com.querydsl.core.types.dsl.DateTimeTemplate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.Union;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractArtifactSearchDAO
extends AbstractPostgreSQLClient {
    private static final Set<String> INDEXED_FIELDS = Sets.newHashSet((Object[])new String[]{"node_id", "project_key", "hidden_in_governable_items_table", "model_type", "saved_model_type"});
    @VisibleForTesting
    protected static final int INSERT_BATCH_SIZE = 500;
    private static final String SQL_TEMP_TABLE_COL_NAME = "artifact_id";
    private static final String TEMPLATE_SQL_TEMP_TABLE_NAME = "search_artifact_ids_%s";
    private static final String TEMPLATE_SQL_CREATE_TEMP_TABLE = "CREATE TEMPORARY TABLE %1$s ( %2$s TEXT) ON COMMIT DROP; CREATE INDEX ON %1$s (%2$s)";
    private static final String TEMPLATE_SQL_INSERT_TEMP_TABLE = "INSERT INTO %s (%s) values(?)";
    private static final String SQL_SUBQUERY_COL_NAME = "ref_artifact_id";
    private static final String SQL_SUBQUERY_REF_ARRAY_COL_NAME = "ref_arr";

    protected abstract RelationalPathBase<?> getRelationalPathBase();

    protected abstract StringExpression getArtifactIdPath();

    protected abstract StringExpression getArtifactBlueprintIdPath();

    protected abstract StringExpression getArtifactVersionIdPath();

    protected abstract Expression<Object> getArtifactJsonWithoutRelationshipsPath();

    protected abstract Expression<Object> getArtifactJsonWithRelationshipsPath();

    protected abstract Expression<Object> getBlueprintVersionJsonPath();

    protected abstract Expression<Object> getSignoffsPath();

    protected abstract StringExpression getUserMappingUserLoginPath();

    protected abstract StringExpression getGroupMappingGroupNamePath();

    protected abstract StringExpression getGlobalApiKeyMappingApiKeyIdPath();

    protected abstract Expression<?> getFromExpressionClause(@Nullable Long var1);

    protected boolean doArtifactFiltersImplyEmptyResultSet(@Nullable List<ArtifactFilter> artifactFilters) {
        if (CollectionUtils.isEmpty(artifactFilters)) {
            return false;
        }
        for (ArtifactFilter artifactFilter : artifactFilters) {
            EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
            artifactFilter.getQueryableArtifactFilter().accept(visitor);
            if (!visitor.impliesEmptyResultSet) continue;
            return true;
        }
        return false;
    }

    protected Predicate buildFiltersPredicates(@Nullable List<? extends ArtifactFilter> filters, CombinationOperation operation, final @Nullable Long timestamp) {
        final ArrayList filterPredicates = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(filters)) {
            filters.stream().map(ArtifactFilter::getQueryableArtifactFilter).forEach(queryableArtifactFilter -> queryableArtifactFilter.accept(new ArtifactFilter.IQueryableArtifactFilterVisitor(){

                private void addFilter(ArtifactFilter filter, Predicate predicate) {
                    filterPredicates.add(filter.negateCondition ? predicate.not() : predicate);
                }

                @Override
                public void visit(ArtifactFilter.BlueprintsArtifactFilter blueprintsArtifactFilter) {
                    this.addFilter(blueprintsArtifactFilter, AbstractArtifactSearchDAO.this.buildBlueprintsArtifactFilterPredicate(blueprintsArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.BlueprintVersionsArtifactFilter blueprintVersionsArtifactFilter) {
                    this.addFilter(blueprintVersionsArtifactFilter, AbstractArtifactSearchDAO.this.buildBlueprintVersionsArtifactFilterPredicate(blueprintVersionsArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.ArtifactsArtifactFilter artifactsArtifactFilter) {
                    this.addFilter(artifactsArtifactFilter, AbstractArtifactSearchDAO.this.buildArtifactsArtifactFilterPredicate(artifactsArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.ArtifactNameFilter artifactNameFilter) {
                    this.addFilter(artifactNameFilter, AbstractArtifactSearchDAO.this.buildArtifactNameFilter(artifactNameFilter));
                }

                @Override
                public void visit(ArtifactFilter.ArtifactIdFilter artifactIdFilter) {
                    this.addFilter(artifactIdFilter, AbstractArtifactSearchDAO.this.buildArtifactIdFilter(artifactIdFilter));
                }

                @Override
                public void visit(ArtifactFilter.FieldValueArtifactFilter fieldValueArtifactFilter) {
                    this.addFilter(fieldValueArtifactFilter, StringUtils.isBlank((CharSequence)fieldValueArtifactFilter.fieldId) ? AbstractArtifactSearchDAO.this.buildGlobalValueFilterPredicate(fieldValueArtifactFilter) : AbstractArtifactSearchDAO.this.buildFieldsValueFilterPredicate(fieldValueArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter) {
                    this.addFilter(typedFieldValueArtifactFilter, (Predicate)AbstractArtifactSearchDAO.this.buildTypedFieldValueArtifactFilterPredicate(typedFieldValueArtifactFilter, timestamp));
                }

                @Override
                public void visit(ArtifactFilter.ArchivedStatusArtifactFilter archivedStatusArtifactFilter) {
                    this.addFilter(archivedStatusArtifactFilter, AbstractArtifactSearchDAO.this.buildArchivedStatusArtifactFilterPredicate(archivedStatusArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.WorkflowStepArtifactFilter workflowStepArtifactFilter) {
                    this.addFilter(workflowStepArtifactFilter, (Predicate)AbstractArtifactSearchDAO.this.buildWorkflowStepArtifactFilterPredicate(workflowStepArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
                    this.addFilter(signoffStatusArtifactFilter, (Predicate)AbstractArtifactSearchDAO.this.buildSignoffStatusArtifactFilterPredicate(signoffStatusArtifactFilter));
                }

                @Override
                public void visit(ArtifactFilter.OrArtifactFilter orArtifactFilter) {
                    this.addFilter(orArtifactFilter, AbstractArtifactSearchDAO.this.buildFiltersPredicates(orArtifactFilter.artifactFilters, CombinationOperation.OR, timestamp));
                }

                @Override
                public void visit(ArtifactFilter.AndArtifactFilter andArtifactFilter) {
                    this.addFilter(andArtifactFilter, AbstractArtifactSearchDAO.this.buildFiltersPredicates(andArtifactFilter.artifactFilters, CombinationOperation.AND, timestamp));
                }
            }));
        }
        if (CollectionUtils.isEmpty((Collection)filterPredicates)) {
            return Expressions.FALSE.isTrue();
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        filterPredicates.forEach(operation == CombinationOperation.AND ? arg_0 -> ((BooleanBuilder)booleanBuilder).and(arg_0) : arg_0 -> ((BooleanBuilder)booleanBuilder).or(arg_0));
        return booleanBuilder.getValue();
    }

    protected Predicate buildFieldLogicPredicate(List<FieldLogic> fieldLogics, CombinationOperation operation, final NumberExpression<Integer> valueIndex, final StringExpression rawValue, final @Nullable Long timestamp) {
        final ArrayList logicPredicates = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(fieldLogics)) {
            fieldLogics.forEach(fieldLogic -> fieldLogic.accept(new FieldLogic.IFieldLogicVisitor(){

                private void addPredicateToList(FieldLogic fieldLogic, Predicate predicate) {
                    if (fieldLogic.indexLogic != null) {
                        predicate = AbstractArtifactSearchDAO.this.buildNumberLogicPredicate(fieldLogic.indexLogic, (NumberExpression<Double>)valueIndex.doubleValue()).and(predicate);
                    }
                    if (fieldLogic.negateCondition) {
                        predicate = predicate.not();
                    }
                    logicPredicates.add(predicate);
                }

                @Override
                public void visit(FieldLogic.TextFieldLogic textFieldLogic) {
                    this.addPredicateToList(textFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildTextLogicPredicate(textFieldLogic, rawValue));
                }

                @Override
                public void visit(FieldLogic.CategoryFieldLogic categoryFieldLogic) {
                    this.addPredicateToList(categoryFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildCategoryLogicPredicate(categoryFieldLogic, rawValue));
                }

                @Override
                public void visit(FieldLogic.NumberFieldLogic numberFieldLogic) {
                    this.addPredicateToList(numberFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildNumberLogicPredicate(numberFieldLogic, rawValue));
                }

                @Override
                public void visit(FieldLogic.DateFieldLogic dateFieldLogic) {
                    this.addPredicateToList(dateFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildDateLogicPredicate(dateFieldLogic, rawValue));
                }

                @Override
                public void visit(FieldLogic.ReferenceFieldLogic referenceFieldLogic) {
                    this.addPredicateToList(referenceFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildReferenceLogicPredicate(referenceFieldLogic, rawValue, timestamp));
                }

                @Override
                public void visit(FieldLogic.BooleanFieldLogic booleanFieldLogic) {
                    this.addPredicateToList(booleanFieldLogic, (Predicate)AbstractArtifactSearchDAO.this.buildBooleanLogicPredicate(booleanFieldLogic, rawValue));
                }

                @Override
                public void visit(FieldLogic.FieldLogicAnd fieldLogicAnd) {
                    this.addPredicateToList(fieldLogicAnd, AbstractArtifactSearchDAO.this.buildFieldLogicPredicate(fieldLogicAnd.logics, CombinationOperation.AND, (NumberExpression<Integer>)valueIndex, rawValue, timestamp));
                }

                @Override
                public void visit(FieldLogic.FieldLogicOr fieldLogicOr) {
                    this.addPredicateToList(fieldLogicOr, AbstractArtifactSearchDAO.this.buildFieldLogicPredicate(fieldLogicOr.logics, CombinationOperation.OR, (NumberExpression<Integer>)valueIndex, rawValue, timestamp));
                }
            }));
        }
        BooleanBuilder booleanBuilder = new BooleanBuilder();
        logicPredicates.forEach(operation == CombinationOperation.AND ? arg_0 -> ((BooleanBuilder)booleanBuilder).and(arg_0) : arg_0 -> ((BooleanBuilder)booleanBuilder).or(arg_0));
        return booleanBuilder.getValue();
    }

    protected void enrichQueryWithFilters(SQLQuery<?> sqlQuery, @Nullable List<ArtifactFilter> filters, @Nullable Long timestamp) {
        if (CollectionUtils.isNotEmpty(filters)) {
            sqlQuery.where(this.buildFiltersPredicates(filters, CombinationOperation.AND, timestamp));
            filters.stream().filter(af -> af instanceof ArtifactFilter.ArtifactsArtifactFilter).filter(aaf -> !aaf.negateCondition).map(aaf -> Sets.newHashSet(((ArtifactFilter.ArtifactsArtifactFilter)aaf).artifactIds).size()).min(Comparator.comparingInt(size -> size)).ifPresent(arg_0 -> sqlQuery.limit(arg_0));
        }
    }

    protected Predicate buildBlueprintsArtifactFilterPredicate(ArtifactFilter.BlueprintsArtifactFilter blueprintsArtifactFilter) {
        if (CollectionUtils.isEmpty(blueprintsArtifactFilter.blueprintIds)) {
            return Expressions.FALSE.isTrue();
        }
        BooleanBuilder cond = new BooleanBuilder();
        for (String blueprintId : blueprintsArtifactFilter.blueprintIds) {
            cond.or((Predicate)this.getArtifactBlueprintIdPath().eq((Object)blueprintId));
        }
        return cond;
    }

    protected Predicate buildBlueprintVersionsArtifactFilterPredicate(ArtifactFilter.BlueprintVersionsArtifactFilter blueprintVersionsArtifactFilter) {
        if (CollectionUtils.isEmpty(blueprintVersionsArtifactFilter.blueprintVersionIds)) {
            return Expressions.FALSE.isTrue();
        }
        BooleanBuilder cond = new BooleanBuilder();
        for (BlueprintVersionId blueprintVersionId : blueprintVersionsArtifactFilter.blueprintVersionIds) {
            cond.or((Predicate)this.getArtifactBlueprintIdPath().eq((Object)blueprintVersionId.blueprintId).and((Predicate)this.getArtifactVersionIdPath().eq((Object)blueprintVersionId.versionId)));
        }
        return cond;
    }

    protected Predicate buildArtifactsArtifactFilterPredicate(ArtifactFilter.ArtifactsArtifactFilter artifactsArtifactFilter) {
        BooleanExpression isInArtifacts;
        if (CollectionUtils.isEmpty(artifactsArtifactFilter.artifactIds)) {
            return Expressions.FALSE;
        }
        HashSet artifactIdsUniques = Sets.newHashSet(artifactsArtifactFilter.artifactIds);
        if (artifactIdsUniques.size() >= Short.MAX_VALUE) {
            String uniqueTempTableName = String.format(TEMPLATE_SQL_TEMP_TABLE_NAME, SecretKeyGenerator.generateSmall());
            String createTempTableQuery = String.format(TEMPLATE_SQL_CREATE_TEMP_TABLE, uniqueTempTableName, SQL_TEMP_TABLE_COL_NAME);
            this.querydslJdbcTemplate.execute(createTempTableQuery);
            this.querydslJdbcTemplate.batchUpdate(String.format(TEMPLATE_SQL_INSERT_TEMP_TABLE, uniqueTempTableName, SQL_TEMP_TABLE_COL_NAME), artifactIdsUniques, 500, (ps, artifactId) -> ps.setString(1, (String)artifactId));
            PathBuilder tempTablePath = new PathBuilder(Tuple.class, uniqueTempTableName);
            isInArtifacts = ((SQLQuery)((SQLQuery)this.sqlQueryFactory.selectOne().from((Expression)tempTablePath)).where((Predicate)tempTablePath.getString(SQL_TEMP_TABLE_COL_NAME).eq((Expression)this.getArtifactIdPath()))).exists();
        } else {
            isInArtifacts = this.getArtifactIdPath().in((Collection)artifactIdsUniques);
        }
        return isInArtifacts;
    }

    protected Predicate buildArtifactNameFilter(ArtifactFilter.ArtifactNameFilter artifactNameFilter) {
        return this.buildTextLogicPredicate(FieldLogic.TextFieldLogic.build(artifactNameFilter.conditionType, artifactNameFilter.condition, artifactNameFilter.caseSensitive), (StringExpression)QueryBuilderUtils.jsonString(this.getArtifactJsonWithoutRelationshipsPath(), "name"));
    }

    protected Predicate buildArtifactIdFilter(ArtifactFilter.ArtifactIdFilter artifactIdFilter) {
        return this.buildTextLogicPredicate(FieldLogic.TextFieldLogic.build(artifactIdFilter.conditionType, artifactIdFilter.condition, artifactIdFilter.caseSensitive), this.getArtifactIdPath());
    }

    protected Predicate buildGlobalValueFilterPredicate(ArtifactFilter.FieldValueArtifactFilter generalFilter) {
        Expression<Object> artifactJsonPath = generalFilter.canBeReference ? this.getArtifactJsonWithRelationshipsPath() : this.getArtifactJsonWithoutRelationshipsPath();
        BooleanExpression booleanExpression = this.fieldValueConditionForStringType(generalFilter.conditionType, generalFilter.condition, generalFilter.caseSensitive, QueryBuilderUtils.jsonObject(this.getArtifactJsonWithoutRelationshipsPath(), "name")).or((Predicate)this.boolOrOnPredicate(alias -> this.fieldValueConditionForAnyType(generalFilter.conditionType, generalFilter.condition, generalFilter.caseSensitive, (SimpleTemplate<Object>)Expressions.template(Object.class, (String)alias, (Object[])new Object[0]), false), alias -> Expressions.template(Object.class, (String)"(SELECT field_values AS {0s} FROM {1} AS field_values WHERE {2})", (Object[])new Object[]{alias, QueryBuilderUtils.jsonPathQuery(artifactJsonPath, "strict $.fields.*"), Expressions.template(Object.class, (String)"field_values", (Object[])new Object[0]).ne(QueryBuilderUtils.JSONB_NULL).and((Predicate)Expressions.template(Object.class, (String)"field_values", (Object[])new Object[0]).ne(QueryBuilderUtils.JSONB_EMPTY_ARRAY))})));
        return generalFilter.negateOperator ? booleanExpression.not() : booleanExpression;
    }

    protected BooleanTemplate boolOrOnPredicate(Function<String, BooleanExpression> booleanExpressionItemMatches, Function<String, Expression<Object>> subTableExpression) {
        return Expressions.booleanTemplate((String)"(SELECT BOOL_OR(item.item_matches) IS TRUE FROM (SELECT {0} AS item_matches FROM {1} AS item_value) AS item)", (Object[])new Object[]{booleanExpressionItemMatches.apply("item_value"), subTableExpression.apply("item_value")});
    }

    protected Predicate buildFieldsValueFilterPredicate(ArtifactFilter.FieldValueArtifactFilter fieldFilter) {
        Expression<Object> artifactJsonPath;
        Expression<Object> expression = artifactJsonPath = fieldFilter.canBeReference ? this.getArtifactJsonWithRelationshipsPath() : this.getArtifactJsonWithoutRelationshipsPath();
        if (fieldFilter.conditionType == ArtifactFilterFieldConditionType.EQUALS && !fieldFilter.negateCondition && !fieldFilter.negateOperator && fieldFilter.caseSensitive && !fieldFilter.canBeReference && StringUtils.isNotBlank((CharSequence)fieldFilter.fieldId) && INDEXED_FIELDS.contains(fieldFilter.fieldId)) {
            StringTemplate fieldExpr = QueryBuilderUtils.jsonString(artifactJsonPath, "fields", fieldFilter.fieldId);
            return fieldFilter.condition == null ? fieldExpr.isNull() : fieldExpr.eq((Expression)Expressions.stringTemplate((String)"{0}", (Object[])new Object[]{fieldFilter.condition}));
        }
        BooleanExpression booleanExpression = this.fieldValueConditionForAnyType(fieldFilter.conditionType, fieldFilter.condition, fieldFilter.caseSensitive, QueryBuilderUtils.jsonObject(artifactJsonPath, "fields", fieldFilter.fieldId), false);
        return fieldFilter.negateOperator ? booleanExpression.not() : booleanExpression;
    }

    protected BooleanExpression fieldValueConditionForAnyType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive, SimpleTemplate<Object> json, boolean forbidArray) {
        StringTemplate typeof = QueryBuilderUtils.jsonTypeof(json);
        BooleanExpression nullCondition = this.fieldValueConditionForNullType(conditionType, condition, json);
        BooleanExpression stringCondition = this.fieldValueConditionForStringType(conditionType, condition, caseSensitive, json);
        BooleanExpression numberCondition = this.fieldValueConditionForNumberType(conditionType, condition, json);
        BooleanExpression booleanCondition = this.fieldValueConditionForBooleanType(conditionType, condition, caseSensitive, json);
        BooleanExpression objectCondition = this.fieldValueConditionForObjectType(conditionType, condition, caseSensitive, json);
        BooleanExpression arrayCondition = forbidArray ? Expressions.FALSE : this.fieldValueConditionForArrayType(conditionType, condition, caseSensitive, json);
        List<Pair> conditionsList = Stream.of(Pair.of((Object)"null", (Object)nullCondition), Pair.of((Object)"string", (Object)stringCondition), Pair.of((Object)"number", (Object)numberCondition), Pair.of((Object)"boolean", (Object)booleanCondition), Pair.of((Object)"object", (Object)objectCondition), Pair.of((Object)"array", (Object)arrayCondition)).filter(p -> !Objects.equals(p.getRight(), Expressions.FALSE)).toList();
        if (conditionsList.isEmpty()) {
            return Expressions.FALSE;
        }
        Pair initialCondition = conditionsList.get(0);
        CaseBuilder.Cases cases = Expressions.cases().when((Predicate)typeof.eq((Expression)Expressions.stringTemplate((String)"'{0s}'", (Object[])new Object[]{initialCondition.getLeft()}))).then((Predicate)initialCondition.getRight());
        if (conditionsList.size() > 1) {
            for (Pair cond : conditionsList.subList(1, conditionsList.size())) {
                cases = cases.when((Predicate)typeof.eq((Expression)Expressions.stringTemplate((String)"'{0s}'", (Object[])new Object[]{cond.getLeft()}))).then((Expression)cond.getRight());
            }
        }
        return (BooleanExpression)cases.otherwise((Expression)Expressions.FALSE);
    }

    protected BooleanExpression fieldValueConditionForArrayType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive, SimpleTemplate<Object> json) {
        if (conditionType != ArtifactFilterFieldConditionType.IS_NULL && conditionType != ArtifactFilterFieldConditionType.CONTAINS) {
            return Expressions.FALSE;
        }
        ArtifactFilterFieldConditionType finalConditionType = conditionType == ArtifactFilterFieldConditionType.CONTAINS ? ArtifactFilterFieldConditionType.EQUALS : conditionType;
        BooleanTemplate booleanExpression = this.boolOrOnPredicate(alias -> this.fieldValueConditionForAnyType(finalConditionType, condition, caseSensitive, (SimpleTemplate<Object>)Expressions.template(Object.class, (String)alias, (Object[])new Object[0]), true), alias -> QueryBuilderUtils.jsonPathQuery(QueryBuilderUtils.toNonEmptyArrayOrArrayContainingNull((Expression<Object>)json), "strict $[*]"));
        if (conditionType == ArtifactFilterFieldConditionType.IS_NULL) {
            return json.eq(QueryBuilderUtils.JSONB_EMPTY_ARRAY).or((Predicate)booleanExpression);
        }
        return booleanExpression;
    }

    protected BooleanExpression fieldValueConditionForNullType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, SimpleTemplate<Object> json) {
        if (conditionType != ArtifactFilterFieldConditionType.IS_NULL && (conditionType != ArtifactFilterFieldConditionType.EQUALS || condition != null)) {
            return Expressions.FALSE;
        }
        return json.eq(QueryBuilderUtils.JSONB_NULL);
    }

    protected BooleanExpression fieldValueConditionForStringType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive, SimpleTemplate<Object> json) {
        if (conditionType == ArtifactFilterFieldConditionType.IS_NULL || condition == null) {
            return Expressions.FALSE;
        }
        Pair<Boolean, Boolean> tappedLeftRight = this.tappedLeftRightForOperator(conditionType);
        String stringBuiltCondition = "strict $ ? (@ like_regex \"" + ((Boolean)tappedLeftRight.getLeft() != false ? "^" : "") + QueryBuilderUtils.escapeJsonPathForRegex(condition) + ((Boolean)tappedLeftRight.getRight() != false ? "$" : "") + "\"" + (caseSensitive ? "" : " flag \"i\"") + ")";
        return QueryBuilderUtils.jsonPathExists(json, stringBuiltCondition);
    }

    protected BooleanExpression fieldValueConditionForNumberType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, SimpleTemplate<Object> json) {
        if (conditionType == ArtifactFilterFieldConditionType.IS_NULL || condition == null) {
            return Expressions.FALSE;
        }
        Double doubleConditionOrNullIfNotADouble = null;
        try {
            doubleConditionOrNullIfNotADouble = Double.valueOf(condition);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String textConditionForNumber = doubleConditionOrNullIfNotADouble != null && DoubleMath.isMathematicalInteger((double)doubleConditionOrNullIfNotADouble) ? String.valueOf(doubleConditionOrNullIfNotADouble.longValue()) : condition;
        boolean hasFirstAPlusOrMinus = textConditionForNumber.startsWith("+") || textConditionForNumber.startsWith("-");
        String prefix = "^" + (hasFirstAPlusOrMinus ? "" : "\\\\+?") + "0*";
        boolean containsADot = textConditionForNumber.contains(".");
        boolean containsAE = textConditionForNumber.toLowerCase().contains("e");
        String suffix = (containsADot || containsAE ? "" : "(\\\\.0*)?") + "$";
        Pair<Boolean, Boolean> tappedLeftRight = this.tappedLeftRightForOperator(conditionType);
        String stringBuiltCondition = "strict $ ? (@ like_regex \"" + (String)((Boolean)tappedLeftRight.getLeft() != false ? prefix : "") + QueryBuilderUtils.escapeJsonPathForRegex(textConditionForNumber) + (String)((Boolean)tappedLeftRight.getRight() != false ? suffix : "") + "\" flag \"i\")";
        BooleanTemplate numberCastedToStringComparison = QueryBuilderUtils.jsonPathExists(QueryBuilderUtils.toJson(QueryBuilderUtils.jsonFirstArrayElementAsText(QueryBuilderUtils.jsonBuildArray(json))), stringBuiltCondition);
        if (conditionType == ArtifactFilterFieldConditionType.EQUALS && doubleConditionOrNullIfNotADouble != null) {
            BooleanTemplate quickWinNumber = QueryBuilderUtils.jsonPathExists(json, "strict $ ? (@ == " + doubleConditionOrNullIfNotADouble + ")");
            return quickWinNumber.or((Predicate)numberCastedToStringComparison);
        }
        return numberCastedToStringComparison;
    }

    protected BooleanExpression fieldValueConditionForBooleanType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive, SimpleTemplate<Object> json) {
        String caseSensitiveCondition;
        if (conditionType == ArtifactFilterFieldConditionType.IS_NULL || condition == null) {
            return Expressions.FALSE;
        }
        Pair<Boolean, Boolean> tappedLeftRight = this.tappedLeftRightForOperator(conditionType);
        String stringBuiltCondition = "strict $ ? (@ like_regex \"" + ((Boolean)tappedLeftRight.getLeft() != false ? "^" : "") + QueryBuilderUtils.escapeJsonPathForRegex(condition) + ((Boolean)tappedLeftRight.getRight() != false ? "$" : "") + "\"" + (caseSensitive ? "" : " flag \"i\"") + ")";
        BooleanTemplate booleanCastedToStringComparison = QueryBuilderUtils.jsonPathExists(QueryBuilderUtils.toJson(QueryBuilderUtils.jsonFirstArrayElementAsText(QueryBuilderUtils.jsonBuildArray(json))), stringBuiltCondition);
        String string = caseSensitiveCondition = caseSensitive ? condition : condition.toLowerCase();
        if (conditionType == ArtifactFilterFieldConditionType.EQUALS && ("true".equals(caseSensitiveCondition) || "false".equals(caseSensitiveCondition))) {
            BooleanTemplate quickWinBoolean = QueryBuilderUtils.jsonPathExists(json, "strict $ ? (@ == " + caseSensitiveCondition + ")");
            return quickWinBoolean.or((Predicate)booleanCastedToStringComparison);
        }
        return booleanCastedToStringComparison;
    }

    protected BooleanExpression fieldValueConditionForObjectType(ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive, SimpleTemplate<Object> json) {
        if (conditionType == ArtifactFilterFieldConditionType.IS_NULL || condition == null) {
            return Expressions.FALSE;
        }
        if (conditionType != ArtifactFilterFieldConditionType.CONTAINS) {
            return Expressions.FALSE;
        }
        return this.fieldValueConditionForStringType(conditionType, condition, caseSensitive, QueryBuilderUtils.jsonObject(json, new String[]{"value"}));
    }

    private Pair<Boolean, Boolean> tappedLeftRightForOperator(ArtifactFilterFieldConditionType artifactFilterFieldConditionType) {
        switch (artifactFilterFieldConditionType) {
            case IS_NULL: 
            case EQUALS: {
                return Pair.of((Object)true, (Object)true);
            }
            case CONTAINS: {
                return Pair.of((Object)false, (Object)false);
            }
            case START_WITH: {
                return Pair.of((Object)true, (Object)false);
            }
            case END_WITH: {
                return Pair.of((Object)false, (Object)true);
            }
        }
        throw new RuntimeException("Unhandled filter type " + String.valueOf((Object)artifactFilterFieldConditionType));
    }

    protected Predicate buildTypedFieldSingleValuePredicate(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter, NumberExpression<Integer> valueIndex, StringExpression rawValue, @Nullable Long timestamp) {
        return this.buildFieldLogicPredicate(Collections.singletonList(typedFieldValueArtifactFilter.fieldLogic), CombinationOperation.AND, valueIndex, rawValue, timestamp);
    }

    private boolean shouldIncludeRelationships(FieldLogic fieldLogic) {
        if (fieldLogic instanceof FieldLogic.ReferenceFieldLogic) {
            return true;
        }
        if (fieldLogic instanceof FieldLogic.FieldLogicCombinator) {
            return ((FieldLogic.FieldLogicCombinator)fieldLogic).logics.stream().anyMatch(this::shouldIncludeRelationships);
        }
        return false;
    }

    protected BooleanExpression buildTypedFieldValueArtifactFilterPredicate(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter, @Nullable Long timestamp) {
        BooleanExpression fieldTypeIsCorrect = QueryBuilderUtils.jsonString(this.getBlueprintVersionJsonPath(), "fieldDefinitions", typedFieldValueArtifactFilter.fieldId, "fieldType").eq((Expression)QueryBuilderUtils.unsafeInQueryConstant(typedFieldValueArtifactFilter.getFieldType()));
        NumberExpression numberOfMatches = Expressions.asNumber((Expression)((Expression)((SQLQuery)SQLExpressions.select((Expression)SQLExpressions.countAll).from((Expression)((SQLQuery)SQLExpressions.select((Expression[])new Expression[]{SQLExpressions.rowNumber().over().as("value_index"), Expressions.stringPath((String)"value").as("raw_value")}).from(QueryBuilderUtils.jsonArrayElementsText(QueryBuilderUtils.toNonEmptyArrayOrArrayContainingNull(QueryBuilderUtils.jsonObjectDefaultSQLNull(this.shouldIncludeRelationships(typedFieldValueArtifactFilter.fieldLogic) ? this.getArtifactJsonWithRelationshipsPath() : this.getArtifactJsonWithoutRelationshipsPath(), "fields", typedFieldValueArtifactFilter.fieldId))))).as("single_value_query"))).where(this.buildTypedFieldSingleValuePredicate(typedFieldValueArtifactFilter, (NumberExpression<Integer>)Expressions.numberPath(Integer.class, (String)"value_index"), (StringExpression)Expressions.stringPath((String)"raw_value"), timestamp))));
        BooleanExpression cardinalityPredicate = this.buildNumberLogicPredicate(typedFieldValueArtifactFilter.cardinalityCondition, (NumberExpression<Double>)numberOfMatches.doubleValue());
        if (typedFieldValueArtifactFilter.cardinalityCondition.negateCondition ^ typedFieldValueArtifactFilter.negateOperator) {
            cardinalityPredicate = cardinalityPredicate.not();
        }
        return (BooleanExpression)Expressions.cases().when((Predicate)fieldTypeIsCorrect).then((Predicate)cardinalityPredicate).otherwise((Expression)Expressions.FALSE);
    }

    protected Predicate buildArchivedStatusArtifactFilterPredicate(ArtifactFilter.ArchivedStatusArtifactFilter archivedStatusArtifactFilter) {
        return QueryBuilderUtils.jsonString(this.getArtifactJsonWithoutRelationshipsPath(), "status", "archived").eq((Expression)Expressions.stringTemplate((String)"{0}", (Object[])new Object[]{archivedStatusArtifactFilter.isArchived ? "true" : "false"}));
    }

    protected BooleanExpression buildWorkflowStepArtifactFilterPredicate(ArtifactFilter.WorkflowStepArtifactFilter workflowStepArtifactFilter) {
        String pathCondition = String.format("@.status %s \"%s\" && @.visible == true", workflowStepArtifactFilter.negateOperator ? "!=" : "==", QueryBuilderUtils.escapeJsonPathForRegex(workflowStepArtifactFilter.status.toString()));
        String pathToField = StringUtils.isNotBlank((CharSequence)workflowStepArtifactFilter.stepId) ? String.format("$.\"%s\"", QueryBuilderUtils.escapeJsonPathForRegex(workflowStepArtifactFilter.stepId)) : "$.*";
        return QueryBuilderUtils.jsonPathExists(QueryBuilderUtils.jsonObject(this.getArtifactJsonWithoutRelationshipsPath(), "workflow", "steps"), String.format("%s ? (%s)", pathToField, pathCondition));
    }

    protected BooleanExpression buildSignoffStatusArtifactFilterPredicate(ArtifactFilter.SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
        if (StringUtils.isBlank((CharSequence)signoffStatusArtifactFilter.stepId)) {
            SQLQuery signoffQuery = (SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).where((Predicate)QSignoffsWithVisibility.asFunctionExpression(this.getFromExpressionClause(null), signoffStatusArtifactFilter.status.toString(), signoffStatusArtifactFilter.negateOperator).isNotNull());
            return signoffQuery.exists();
        }
        String signoffPathCondition = String.format("@.status %s \"%s\" && @.signoffId.stepId == \"%s\"", signoffStatusArtifactFilter.negateOperator ? "!=" : "==", QueryBuilderUtils.escapeJsonPathForRegex(signoffStatusArtifactFilter.status.toString()), QueryBuilderUtils.escapeJsonPathForRegex(signoffStatusArtifactFilter.stepId));
        return QueryBuilderUtils.jsonPathExists(this.getSignoffsPath(), String.format("$[*] ? (%s)", signoffPathCondition)).and((Predicate)QueryBuilderUtils.jsonPathExists(QueryBuilderUtils.jsonObject(this.getArtifactJsonWithoutRelationshipsPath(), "workflow", "steps"), String.format("$.\"%s\" ? (%s)", QueryBuilderUtils.escapeJsonPathForRegex(signoffStatusArtifactFilter.stepId), "@.visible == true")));
    }

    protected BooleanExpression buildTextLogicPredicate(FieldLogic.TextFieldLogic textFieldLogic, StringExpression rawValue) {
        boolean caseSensitive = textFieldLogic.caseSensitive;
        String condition = textFieldLogic.condition;
        switch (textFieldLogic.conditionType) {
            case EQUALS: {
                return caseSensitive ? rawValue.eq((Object)condition) : rawValue.equalsIgnoreCase(condition);
            }
            case CONTAINS: {
                return caseSensitive ? rawValue.contains(condition) : rawValue.containsIgnoreCase(condition);
            }
            case START_WITH: {
                return caseSensitive ? rawValue.startsWith(condition) : rawValue.startsWithIgnoreCase(condition);
            }
            case END_WITH: {
                return caseSensitive ? rawValue.endsWith(condition) : rawValue.endsWithIgnoreCase(condition);
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)textFieldLogic.conditionType));
    }

    protected BooleanExpression buildCategoryLogicPredicate(FieldLogic.CategoryFieldLogic categoryFieldLogic, StringExpression rawValue) {
        if (CollectionUtils.isEmpty(categoryFieldLogic.condition)) {
            return Expressions.FALSE;
        }
        return rawValue.in(categoryFieldLogic.condition);
    }

    protected BooleanExpression buildNumberLogicPredicate(FieldLogic.NumberFieldLogic numberFieldLogic, StringExpression rawValue) {
        return this.buildNumberLogicPredicate(numberFieldLogic, (NumberExpression<Double>)rawValue.castToNum(Double.class));
    }

    protected BooleanExpression buildNumberLogicPredicate(FieldLogic.NumberFieldLogic numberFieldLogic, NumberExpression<Double> value) {
        if (Objects.equals(numberFieldLogic.condition, Double.NaN)) {
            return numberFieldLogic.conditionType == NumberConditionType.UNEQUALS ? Expressions.TRUE : Expressions.FALSE;
        }
        switch (numberFieldLogic.conditionType) {
            case EQUALS: {
                return value.eq((Object)numberFieldLogic.condition);
            }
            case UNEQUALS: {
                return value.ne((Object)numberFieldLogic.condition);
            }
            case GREATER_THAN: {
                return value.gt((Number)numberFieldLogic.condition);
            }
            case GREATER_OR_EQUAL: {
                return value.goe((Number)numberFieldLogic.condition);
            }
            case LESS_THAN: {
                return value.lt((Number)numberFieldLogic.condition);
            }
            case LESS_OR_EQUAL: {
                return value.loe((Number)numberFieldLogic.condition);
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)numberFieldLogic.conditionType));
    }

    protected BooleanExpression buildDateLogicPredicate(FieldLogic.DateFieldLogic dateFieldLogic, StringExpression rawValue) {
        Either<OffsetDateTime, LocalDate> parsedCondition = DateUtils.parseDate(dateFieldLogic.condition);
        BooleanExpression fieldExprIsDatetime = rawValue.length().gt(QueryBuilderUtils.unsafeInQueryConstant(10));
        DateTimeTemplate fieldExprAsDatetime = Expressions.dateTimeTemplate(OffsetDateTime.class, (String)"REGEXP_REPLACE({0}, '\\[.*\\]', '')::TIMESTAMPTZ", (Object[])new Object[]{rawValue});
        BooleanExpression fieldExprIsDate = rawValue.length().eq(QueryBuilderUtils.unsafeInQueryConstant(10));
        DateTemplate fieldExprAsDate = Expressions.dateTemplate(LocalDate.class, (String)"REGEXP_REPLACE({0}, '\\[.*\\]', '')::DATE", (Object[])new Object[]{rawValue});
        return parsedCondition.isLeft() ? fieldExprIsDatetime.and((Predicate)this.buildDateLogicPredicate_noTypeCheck(dateFieldLogic.conditionType, (TemporalExpression)fieldExprAsDatetime, (Temporal & Comparable<?>)parsedCondition.getLeft())) : fieldExprIsDate.and((Predicate)this.buildDateLogicPredicate_noTypeCheck(dateFieldLogic.conditionType, (TemporalExpression)fieldExprAsDate, (Temporal & Comparable<?>)parsedCondition.getRight()));
    }

    private <T extends Temporal & Comparable<?>> BooleanExpression buildDateLogicPredicate_noTypeCheck(DateConditionType conditionType, TemporalExpression<T> fieldExpr, T condition) {
        switch (conditionType) {
            case EQUALS: {
                return fieldExpr.eq(condition);
            }
            case AFTER: {
                return fieldExpr.after(condition);
            }
            case AFTER_OR_EQUAL: {
                return fieldExpr.after(condition).or((Predicate)fieldExpr.eq(condition));
            }
            case BEFORE: {
                return fieldExpr.before(condition);
            }
            case BEFORE_OR_EQUAL: {
                return fieldExpr.before(condition).or((Predicate)fieldExpr.eq(condition));
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)conditionType));
    }

    protected BooleanExpression buildReferenceLogicPredicate(FieldLogic.ReferenceFieldLogic referenceFieldLogic, StringExpression rawValue, @Nullable Long timestamp) {
        if (referenceFieldLogic.artifactFilter instanceof ArtifactFilter.ArtifactsArtifactFilter) {
            ArtifactFilter.ArtifactsArtifactFilter filter = (ArtifactFilter.ArtifactsArtifactFilter)referenceFieldLogic.artifactFilter;
            return CollectionUtils.isEmpty(filter.artifactIds) ? Expressions.FALSE : (BooleanExpression)Expressions.cases().when((Predicate)rawValue.coalesce(new Expression[]{QueryBuilderUtils.EMPTY_TEXT_EXPRESSION}).asString().ne((Expression)QueryBuilderUtils.EMPTY_TEXT_EXPRESSION)).then((Predicate)rawValue.in(filter.artifactIds)).otherwise((Expression)Expressions.FALSE);
        }
        SQLQuery<?> subquery = this.buildQueryWithArtifactSource(new ArtifactSearchSourceConfig.AllArtifactSearchSource(), timestamp);
        this.enrichQueryWithFilters(subquery, Collections.singletonList(referenceFieldLogic.artifactFilter), timestamp);
        return (BooleanExpression)Expressions.cases().when((Predicate)rawValue.coalesce(new Expression[]{QueryBuilderUtils.EMPTY_TEXT_EXPRESSION}).asString().ne((Expression)QueryBuilderUtils.EMPTY_TEXT_EXPRESSION)).then((Predicate)rawValue.in((SubQueryExpression)subquery.select((Expression)QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId))).otherwise((Expression)Expressions.FALSE);
    }

    protected BooleanExpression buildBooleanLogicPredicate(FieldLogic.BooleanFieldLogic booleanFieldLogic, StringExpression rawValue) {
        switch (booleanFieldLogic.conditionType) {
            case IS_TRUE: {
                return rawValue.eq((Object)"true");
            }
            case IS_FALSE: {
                return rawValue.eq((Object)"false");
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)booleanFieldLogic.conditionType));
    }

    protected void enrichQueryWithSort(SQLQuery<?> sqlQuery, @Nullable ArtifactSearchSort artifactSearchSort) {
        boolean ascSorting;
        if (artifactSearchSort == null) {
            return;
        }
        ArtifactSearchSort.SortColumn column = artifactSearchSort.column;
        ArtifactSearchSort.SortDirection direction = artifactSearchSort.direction;
        boolean bl = ascSorting = direction == ArtifactSearchSort.SortDirection.ASC;
        if (column instanceof ArtifactSearchSort.NameSortColumn) {
            sqlQuery.orderBy(QueryBuilderUtils.order(QueryBuilderUtils.jsonString(this.getArtifactJsonWithoutRelationshipsPath(), "name").lower(), ascSorting));
        } else if (column instanceof ArtifactSearchSort.WorkflowSortColumn) {
            ((SQLQuery)((SQLQuery)sqlQuery.join(QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusQuery, (Path)QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias)).on((Predicate)this.getArtifactIdPath().eq((Expression)QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.artifactId))).orderBy(new OrderSpecifier[]{QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.workflowStatus.eq(QueryBuilderUtils.unsafeInQueryConstant(0)).asc(), QueryBuilderUtils.order(QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.workflowStatus, ascSorting), QueryBuilderUtils.order(QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.workflowProgress, ascSorting), QueryBuilderUtils.order(QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.nbSteps, ascSorting), QueryBuilderUtils.order(QArtifactWorkflowCurrentStatus.artifactWorkflowCurrentStatusAlias.nbVisibleSteps, ascSorting), QueryBuilderUtils.order(this.getArtifactBlueprintIdPath(), ascSorting).nullsLast(), QueryBuilderUtils.order(this.getArtifactVersionIdPath(), ascSorting).nullsLast(), QueryBuilderUtils.order(Expressions.asComparable((Expression)this.getArtifactIdPath()), ascSorting)});
        } else if (column instanceof ArtifactSearchSort.FieldSortColumn && !CollectionUtils.isEmpty(((ArtifactSearchSort.FieldSortColumn)column).fields)) {
            List<StringTemplate> sortingFieldValueExpressions = this.buildFieldsSortCases(((ArtifactSearchSort.FieldSortColumn)column).fields);
            sqlQuery.orderBy(sortingFieldValueExpressions.stream().map(sort -> QueryBuilderUtils.order(sort, ascSorting)).toList().toArray(new OrderSpecifier[0]));
        }
    }

    protected List<StringTemplate> buildFieldsSortCases(List<ArtifactSearchSort.FieldSortColumnField> fieldSortColumnFields) {
        return this.breakdownFieldSortColumns(fieldSortColumnFields).stream().map(this::buildWhenTemplateForFieldsSort).toList();
    }

    private List<List<ArtifactSearchSort.FieldSortColumnField>> breakdownFieldSortColumns(List<ArtifactSearchSort.FieldSortColumnField> fieldSortColumnFields) {
        ArrayList<List<ArtifactSearchSort.FieldSortColumnField>> brokenDown = new ArrayList<List<ArtifactSearchSort.FieldSortColumnField>>();
        HashSet<String> currentBreakers = new HashSet<String>();
        ArrayList<ArtifactSearchSort.FieldSortColumnField> currentList = new ArrayList<ArtifactSearchSort.FieldSortColumnField>();
        brokenDown.add(currentList);
        Iterator<ArtifactSearchSort.FieldSortColumnField> iterator = fieldSortColumnFields.iterator();
        while (iterator.hasNext()) {
            ArtifactSearchSort.FieldSortColumnField fieldSortColumnField = iterator.next();
            if (fieldSortColumnField.blueprintId == null) {
                if (currentList.isEmpty()) {
                    currentList.add(fieldSortColumnField);
                } else {
                    brokenDown.add(List.of(fieldSortColumnField));
                }
                if (iterator.hasNext()) {
                    currentList = new ArrayList();
                    brokenDown.add(currentList);
                }
                currentBreakers.clear();
                continue;
            }
            if (currentBreakers.contains(fieldSortColumnField.blueprintId)) {
                currentBreakers.clear();
                currentList = new ArrayList();
                currentList.add(fieldSortColumnField);
                brokenDown.add(currentList);
                currentBreakers.add(fieldSortColumnField.blueprintId);
                continue;
            }
            currentBreakers.add(fieldSortColumnField.blueprintId);
            currentList.add(fieldSortColumnField);
        }
        return brokenDown;
    }

    private StringTemplate buildWhenTemplateForFieldsSort(List<ArtifactSearchSort.FieldSortColumnField> fieldSortColumnFields) {
        if (fieldSortColumnFields.size() == 1 && fieldSortColumnFields.get((int)0).blueprintId == null) {
            ArtifactSearchSort.FieldSortColumnField fieldSortColumnField2 = fieldSortColumnFields.get(0);
            return Expressions.stringTemplate((String)"CASE {0} WHEN JSONB 'null' THEN NULL ELSE {0} END", (Object[])new Object[]{QueryBuilderUtils.jsonObject(fieldSortColumnField2.canBeReference ? this.getArtifactJsonWithRelationshipsPath() : this.getArtifactJsonWithoutRelationshipsPath(), "fields", fieldSortColumnField2.fieldId)});
        }
        String whenTemplate = IntStream.range(0, fieldSortColumnFields.size()).mapToObj(i -> "WHEN {" + i * 3 + "} = {" + (i * 3 + 1) + "} THEN CASE {" + (i * 3 + 2) + "} WHEN JSONB 'null' THEN NULL ELSE {" + (i * 3 + 2) + "} END").collect(Collectors.joining(" "));
        return Expressions.stringTemplate((String)("CASE " + whenTemplate + " ELSE NULL END"), (Object[])fieldSortColumnFields.stream().flatMap(fieldSortColumnField -> Stream.of(this.getArtifactBlueprintIdPath(), fieldSortColumnField.blueprintId, QueryBuilderUtils.jsonObject(fieldSortColumnField.canBeReference ? this.getArtifactJsonWithRelationshipsPath() : this.getArtifactJsonWithoutRelationshipsPath(), "fields", fieldSortColumnField.fieldId))).toArray());
    }

    protected SQLQuery<?> buildQueryWithArtifactSource(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable Long timestamp) {
        if (artifactSearchSource == null) {
            throw new ValidationException("ArtifactSearchSource can't be null");
        }
        if (artifactSearchSource instanceof ArtifactSearchSourceConfig.AllArtifactSearchSource) {
            return (SQLQuery)this.sqlQueryFactory.from(this.getFromExpressionClause(timestamp));
        }
        if (artifactSearchSource instanceof ArtifactSearchSourceConfig.SubqueriesArtifactSearchSource) {
            return this.buildQueryWithSubqueriesArtifactSearchSource((ArtifactSearchSourceConfig.SubqueriesArtifactSearchSource)artifactSearchSource, timestamp);
        }
        throw new ValidationException("Unknown ArtifactSearchSource type: " + artifactSearchSource.getClass().getSimpleName());
    }

    protected SQLQuery<?> buildQueryWithSubqueriesArtifactSearchSource(ArtifactSearchSourceConfig.SubqueriesArtifactSearchSource artifactSearchSource, @Nullable Long timestamp) {
        List preparedsSubqueries = artifactSearchSource.subqueriesArtifactSearchSourceConfigs.stream().map(subqueryArtifactSearchSourceConfig -> this.prepareSubSQLQuery((SubqueryArtifactSearchSourceConfig)subqueryArtifactSearchSourceConfig, timestamp)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preparedsSubqueries)) {
            Union subqueryAllUnion = new SQLQuery().unionAll(preparedsSubqueries);
            PathBuilder allUnionPath = new PathBuilder(Object.class, "subqueries");
            SQLQuery sourceQuery = (SQLQuery)this.sqlQueryFactory.selectDistinct((Expression)allUnionPath.getString(SQL_SUBQUERY_COL_NAME)).from((SubQueryExpression)subqueryAllUnion, (Path)allUnionPath);
            PathBuilder sourcePath = new PathBuilder(Object.class, "source");
            SQLQuery artifactsQuery = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QueryBuilderUtils.allSortedProjections(this.getRelationalPathBase())).from(this.getFromExpressionClause(timestamp))).where((Predicate)this.getArtifactIdPath().eq((Expression)sourcePath.get(SQL_SUBQUERY_COL_NAME)))).limit(1L);
            return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.from((SubQueryExpression)sourceQuery, (Path)sourcePath)).leftJoin((SubQueryExpression)artifactsQuery, this.getRelationalPathBase())).addJoinFlag(" LATERAL ", JoinFlag.Position.BEFORE_TARGET)).on((Predicate)Expressions.TRUE);
        }
        return (SQLQuery)((SQLQuery)this.sqlQueryFactory.from(this.getFromExpressionClause(timestamp))).where((Predicate)Expressions.FALSE);
    }

    @Nullable
    protected SQLQuery<String> prepareSubSQLQuery(SubqueryArtifactSearchSourceConfig subqueryArtifactSearchSourceConfig, @Nullable Long timestamp) {
        if (subqueryArtifactSearchSourceConfig.artifactSearchSource == null || subqueryArtifactSearchSourceConfig.artifactSearchSource.isSearchSourceEmpty() || this.doArtifactFiltersImplyEmptyResultSet(subqueryArtifactSearchSourceConfig.artifactFilters)) {
            return null;
        }
        if (subqueryArtifactSearchSourceConfig instanceof SubqueryArtifactSearchSourceConfig.Reference) {
            String fieldId = ((SubqueryArtifactSearchSourceConfig.Reference)subqueryArtifactSearchSourceConfig).fieldId;
            SQLQuery<?> refFieldToArrayQuery = this.buildQueryWithArtifactSource(subqueryArtifactSearchSourceConfig.artifactSearchSource, timestamp);
            this.enrichQueryWithFilters(refFieldToArrayQuery, subqueryArtifactSearchSourceConfig.artifactFilters, timestamp);
            refFieldToArrayQuery.select((Expression)QueryBuilderUtils.toNonEmptyArrayOrArrayContainingNull(QueryBuilderUtils.jsonObject(this.getArtifactJsonWithRelationshipsPath(), "fields", fieldId)).as(SQL_SUBQUERY_REF_ARRAY_COL_NAME));
            PathBuilder refFieldToArrayPath = new PathBuilder(Object.class, "all_ref_fields_to_array");
            PathBuilder arrayToRowsPath = new PathBuilder(Object.class, "arr_to_rows");
            return (SQLQuery)((SQLQuery)this.sqlQueryFactory.select((Expression)QueryBuilderUtils.castColumnToString(arrayToRowsPath.get("value")).as(SQL_SUBQUERY_COL_NAME)).with((Path)refFieldToArrayPath, refFieldToArrayQuery)).from(new Expression[]{refFieldToArrayPath, QueryBuilderUtils.jsonArrayElementsText((Expression<Object>)refFieldToArrayPath.get(SQL_SUBQUERY_REF_ARRAY_COL_NAME)).as((Path)arrayToRowsPath)});
        }
        if (subqueryArtifactSearchSourceConfig instanceof SubqueryArtifactSearchSourceConfig.Self) {
            SQLQuery<?> sqlSubquery = this.buildQueryWithArtifactSource(subqueryArtifactSearchSourceConfig.artifactSearchSource, timestamp);
            this.enrichQueryWithFilters(sqlSubquery, subqueryArtifactSearchSourceConfig.artifactFilters, timestamp);
            return sqlSubquery.select((Expression)this.getArtifactIdPath().as(SQL_SUBQUERY_COL_NAME));
        }
        throw new ValidationException("Unknown SubqueryArtifactSearchSourceConfig type: " + subqueryArtifactSearchSourceConfig.getClass().getSimpleName());
    }

    private static class EmptyResultSetArtifactFilterComputer
    implements ArtifactFilter.IQueryableArtifactFilterVisitor,
    FieldLogic.IFieldLogicVisitor {
        public boolean impliesEmptyResultSet = false;

        private EmptyResultSetArtifactFilterComputer() {
        }

        @Override
        public void visit(ArtifactFilter.BlueprintsArtifactFilter blueprintsArtifactFilter) {
            if (CollectionUtils.isEmpty(blueprintsArtifactFilter.blueprintIds) && !blueprintsArtifactFilter.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(ArtifactFilter.BlueprintVersionsArtifactFilter blueprintVersionArtifactFilter) {
            if (CollectionUtils.isEmpty(blueprintVersionArtifactFilter.blueprintVersionIds) && !blueprintVersionArtifactFilter.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(ArtifactFilter.ArtifactsArtifactFilter artifactsArtifactFilter) {
            if (CollectionUtils.isEmpty(artifactsArtifactFilter.artifactIds) && !artifactsArtifactFilter.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(ArtifactFilter.ArtifactNameFilter artifactNameFilter) {
            if (StringUtils.isBlank((CharSequence)artifactNameFilter.condition) && artifactNameFilter.conditionType == TextConditionType.EQUALS && !artifactNameFilter.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(ArtifactFilter.ArtifactIdFilter artifactIdFilter) {
            if (StringUtils.isBlank((CharSequence)artifactIdFilter.condition) && artifactIdFilter.conditionType == TextConditionType.EQUALS && !artifactIdFilter.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(ArtifactFilter.FieldValueArtifactFilter fieldValueArtifactFilter) {
        }

        @Override
        public void visit(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter) {
            if (!typedFieldValueArtifactFilter.negateCondition) {
                if (StringUtils.isBlank((CharSequence)typedFieldValueArtifactFilter.fieldId)) {
                    this.impliesEmptyResultSet = true;
                } else if (typedFieldValueArtifactFilter.cardinalityCondition.conditionType == NumberConditionType.GREATER_OR_EQUAL && typedFieldValueArtifactFilter.cardinalityCondition.condition == 1.0 && !typedFieldValueArtifactFilter.cardinalityCondition.negateCondition) {
                    EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
                    typedFieldValueArtifactFilter.fieldLogic.accept(visitor);
                    this.impliesEmptyResultSet = visitor.impliesEmptyResultSet;
                }
            }
        }

        @Override
        public void visit(ArtifactFilter.ArchivedStatusArtifactFilter archivedStatusArtifactFilter) {
        }

        @Override
        public void visit(ArtifactFilter.WorkflowStepArtifactFilter workflowStepArtifactFilter) {
        }

        @Override
        public void visit(ArtifactFilter.SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
        }

        @Override
        public void visit(ArtifactFilter.OrArtifactFilter orArtifactFilter) {
            if (orArtifactFilter.negateCondition) {
                this.impliesEmptyResultSet = false;
            } else if (CollectionUtils.isEmpty(orArtifactFilter.artifactFilters)) {
                this.impliesEmptyResultSet = true;
            } else {
                ArrayList<Boolean> visitorOutputs = new ArrayList<Boolean>(orArtifactFilter.artifactFilters.size());
                for (ArtifactFilter artifactFilter : orArtifactFilter.artifactFilters) {
                    EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
                    artifactFilter.getQueryableArtifactFilter().accept(visitor);
                    visitorOutputs.add(visitor.impliesEmptyResultSet);
                }
                this.impliesEmptyResultSet = visitorOutputs.stream().allMatch(aBoolean -> aBoolean);
            }
        }

        @Override
        public void visit(ArtifactFilter.AndArtifactFilter andArtifactFilter) {
            if (andArtifactFilter.negateCondition) {
                this.impliesEmptyResultSet = false;
            } else if (CollectionUtils.isEmpty(andArtifactFilter.artifactFilters)) {
                this.impliesEmptyResultSet = true;
            } else {
                ArrayList<Boolean> visitorOutputs = new ArrayList<Boolean>(andArtifactFilter.artifactFilters.size());
                for (ArtifactFilter artifactFilter : andArtifactFilter.artifactFilters) {
                    EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
                    artifactFilter.getQueryableArtifactFilter().accept(visitor);
                    visitorOutputs.add(visitor.impliesEmptyResultSet);
                }
                this.impliesEmptyResultSet = visitorOutputs.stream().anyMatch(aBoolean -> aBoolean);
            }
        }

        @Override
        public void visit(FieldLogic.ReferenceFieldLogic referenceFieldLogic) {
            EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
            referenceFieldLogic.artifactFilter.getQueryableArtifactFilter().accept(visitor);
            if (visitor.impliesEmptyResultSet && !referenceFieldLogic.negateCondition) {
                this.impliesEmptyResultSet = true;
            }
        }

        @Override
        public void visit(FieldLogic.FieldLogicOr fieldLogicOr) {
            if (fieldLogicOr.negateCondition) {
                this.impliesEmptyResultSet = false;
            } else if (CollectionUtils.isEmpty((Collection)fieldLogicOr.logics)) {
                this.impliesEmptyResultSet = true;
            } else {
                ArrayList<Boolean> visitorOutputs = new ArrayList<Boolean>(fieldLogicOr.logics.size());
                for (FieldLogic fieldLogic : fieldLogicOr.logics) {
                    EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
                    fieldLogic.accept(visitor);
                    visitorOutputs.add(visitor.impliesEmptyResultSet);
                }
                this.impliesEmptyResultSet = visitorOutputs.stream().allMatch(aBoolean -> aBoolean);
            }
        }

        @Override
        public void visit(FieldLogic.FieldLogicAnd fieldLogicAnd) {
            if (fieldLogicAnd.negateCondition) {
                this.impliesEmptyResultSet = false;
            } else if (CollectionUtils.isEmpty((Collection)fieldLogicAnd.logics)) {
                this.impliesEmptyResultSet = true;
            } else {
                ArrayList<Boolean> visitorOutputs = new ArrayList<Boolean>(fieldLogicAnd.logics.size());
                for (FieldLogic fieldLogic : fieldLogicAnd.logics) {
                    EmptyResultSetArtifactFilterComputer visitor = new EmptyResultSetArtifactFilterComputer();
                    fieldLogic.accept(visitor);
                    visitorOutputs.add(visitor.impliesEmptyResultSet);
                }
                this.impliesEmptyResultSet = visitorOutputs.stream().anyMatch(aBoolean -> aBoolean);
            }
        }
    }

    static enum CombinationOperation {
        OR,
        AND;

    }
}

