/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.SecurityCodes;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.util.PasswordUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.gh.security.model.PublicUser;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public interface UsersDAO {
    public List<User> listUsers() throws IOException;

    public List<User> listUsersUnsafe() throws IOException;

    public List<Group> listGroups() throws IOException;

    public List<Group> listGroupsUnsafe() throws IOException;

    public User getOrNull(String var1) throws IOException;

    public User getOrNullUnsafe(String var1) throws IOException;

    public User getMandatory(String var1) throws IOException;

    public User getMandatoryUnsafe(String var1) throws IOException;

    public User getUserIgnoreCaseOrNull(String var1) throws IOException;

    public Group getGroup(String var1) throws IOException;

    public Group getGroupUnsafe(String var1) throws IOException;

    public Group getGroupMandatory(String var1) throws IOException;

    public Group getGroupMandatoryUnsafe(String var1) throws IOException;

    public Group getDefaultAdminGroup(boolean var1) throws IOException, CodedException;

    public Group addGroup(String var1, UserSourceType var2) throws IOException, CodedException;

    public Group addGroup(Group var1) throws IOException, CodedException;

    public GroupDiff saveGroup(Group var1) throws IOException;

    public void deleteGroup(String var1) throws IOException;

    public boolean checkLogin(String var1, String var2) throws IOException, CodedException;

    public boolean checkLoginIgnoreCase(String var1, String var2) throws IOException, CodedException;

    default public User addUser(String login, String password) throws IOException, CodedException {
        if (this.getOrNull(login) != null) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_USER_EXISTS, "User '" + login + "' already exists");
        }
        User user = new User(login, password);
        user.creationDate = System.currentTimeMillis();
        this.saveUser(user);
        return user;
    }

    default public void addForeignUser(User user) throws IOException, CodedException {
        if (this.getOrNull(user.login) != null) {
            throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_USER_EXISTS, "User '" + user.login + "' already exists");
        }
        user.creationDate = System.currentTimeMillis();
        this.saveUser(user);
    }

    public UserDiff saveUser(User var1) throws IOException;

    public void deleteUser(String var1) throws IOException;

    public void forceDeleteUser(String var1) throws IOException;

    public List<PublicUser> getPublicUsers(Collection<String> var1) throws IOException;

    public PublicUser getPublicUser(String var1) throws IOException;

    public InputStream getUserPicture(String var1, String var2) throws IOException;

    public void setUserPicture(String var1, InputStream var2, String var3) throws IOException;

    public void clearUserPictures(String var1) throws IOException;

    public static class User
    implements DkuUser {
        static final int PASSWORD_MIN_LENGTH = 5;
        public String login;
        public String displayName;
        public String email;
        public Long creationDate;
        public List<String> groups = new ArrayList<String>();
        public UserSourceType sourceType = UserSourceType.LOCAL;
        public String userProfile;
        public boolean enabled = true;
        private String password;
        public JsonObject adminProperties = new JsonObject();
        public JsonObject userProperties = new JsonObject();

        public void setSecurePassword(String pwd) throws CodedException {
            if (this.sourceType != UserSourceType.LOCAL) {
                throw ErrorContext.iae((String)("User is not local: " + this.login));
            }
            this.checkPasswordSecurity(pwd);
            this.password = PasswordUtils.encryptPassword((String)pwd);
        }

        public void checkPasswordSecurity(String pwd) throws CodedException {
            if (StringUtils.isBlank((String)pwd)) {
                throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_NEW_PASSWORD, "Password is required");
            }
            if (pwd.length() < 5) {
                throw new CodedException((InfoMessage.MessageCode)SecurityCodes.ERR_SECURITY_INVALID_NEW_PASSWORD, "Password is too short. It must be at least 5 characters long");
            }
        }

        public boolean checkPassword(String pwd) throws CodedException {
            return PasswordUtils.verifyPassword((String)pwd, (String)this.password);
        }

        public boolean isWelcomeEmailSent() {
            return false;
        }

        public User() {
        }

        public User(String login, UserSourceType sourceType) {
            this.login = login;
            this.sourceType = sourceType;
        }

        public User(String login, String password) throws CodedException {
            this.login = login;
            this.displayName = login;
            if (password != null) {
                this.setSecurePassword(password);
            }
        }

        public User(UsersService.UIUser u) {
            this.login = u.login;
            this.sourceType = u.sourceType;
            this.displayName = u.displayName;
            this.groups = u.groups;
            this.email = u.email;
            this.enabled = u.enabled;
            this.creationDate = u.creationDate;
            this.userProfile = u.userProfile;
        }

        public String getLogin() {
            return this.login;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getUserProfile() {
            return this.userProfile;
        }

        public void setUserProfile(String userProfile) {
            this.userProfile = userProfile;
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public List<String> getGroups() {
            return this.groups;
        }

        public void addGroupMembership(String group) {
            if (!this.groups.contains(group)) {
                this.groups.add(group);
            }
        }

        public void removeGroupMembership(String group) {
            this.groups.remove(group);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @VisibleForTesting
        public User(User toClone) {
            this.login = toClone.login;
            this.email = toClone.email;
            this.displayName = toClone.displayName;
            this.creationDate = toClone.creationDate;
            this.groups = new ArrayList<String>(toClone.groups);
            this.sourceType = toClone.sourceType;
            this.userProfile = toClone.userProfile;
            this.enabled = toClone.enabled;
            this.password = toClone.password;
            this.adminProperties = toClone.adminProperties.deepCopy();
            this.userProperties = toClone.userProperties.deepCopy();
        }

        public String toString() {
            return "User{login='" + this.login + "', displayName='" + this.displayName + "', email='" + this.email + "', groups=" + String.valueOf(this.groups) + ", sourceType=" + String.valueOf(this.sourceType) + ", userProfile='" + this.userProfile + "', enabled=" + this.enabled + "}";
        }
    }

    @UIModel
    public static class Group
    extends GroupPermissions
    implements DkuGroup {
        public String name;
        public String description = "";
        public List<String> ldapGroupNames = new ArrayList<String>();
        public List<String> azureADGroupNames = new ArrayList<String>();
        public List<String> ssoGroupNames = new ArrayList<String>();
        public List<String> customGroupNames = new ArrayList<String>();
        public UserSourceType sourceType = UserSourceType.LOCAL;

        public Set<String> getExternalGroupNames() {
            switch (this.sourceType) {
                case LOCAL: 
                case SAAS: 
                case PAM: {
                    return Collections.emptySet();
                }
                case LOCAL_NO_AUTH: {
                    return new HashSet<String>(this.ssoGroupNames);
                }
                case LDAP: {
                    return new HashSet<String>(this.ldapGroupNames);
                }
                case AZURE_AD: {
                    return new HashSet<String>(this.azureADGroupNames);
                }
                case CUSTOM: {
                    return new HashSet<String>(this.customGroupNames);
                }
            }
            return Collections.emptySet();
        }

        public UserSourceType getUserSourceType() {
            return this.sourceType;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Group() {
        }

        public Group(Group group) {
            super(group);
            this.name = group.name;
            this.description = group.description;
            this.sourceType = group.sourceType;
            this.ldapGroupNames = group.ldapGroupNames;
            this.azureADGroupNames = group.azureADGroupNames;
            this.ssoGroupNames = group.ssoGroupNames;
            this.customGroupNames = group.customGroupNames;
        }

        @Override
        public Group deepCopy() {
            return new Group(this);
        }
    }

    @UIModel
    public static class GroupPermissions {
        protected boolean admin;
        public Boolean dataikerAdmin;
        protected boolean mayManageGovern;

        public GroupPermissions() {
        }

        public GroupPermissions(GroupPermissions groupPermissions) {
            this.admin = groupPermissions.admin;
            this.dataikerAdmin = groupPermissions.dataikerAdmin;
            this.mayManageGovern = groupPermissions.mayManageGovern;
        }

        public GroupPermissions deepCopy() {
            return new GroupPermissions(this);
        }

        public GroupPermissions withAdmin(boolean admin) {
            this.admin = admin;
            return this;
        }

        public GroupPermissions getResolved() {
            GroupPermissions resolved = new GroupPermissions();
            resolved.admin = this.isAdmin();
            resolved.dataikerAdmin = this.dataikerAdmin;
            resolved.mayManageGovern = this.mayManageGovern();
            return resolved;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public void setAdmin(boolean admin) {
            this.admin = admin;
        }

        public GroupPermissions union(GroupPermissions permissions) {
            GroupPermissions result = new GroupPermissions();
            boolean bl = result.admin = this.admin || permissions.admin;
            result.dataikerAdmin = this.dataikerAdmin == null && permissions.dataikerAdmin == null ? null : Boolean.valueOf(this.dataikerAdmin != null && this.dataikerAdmin != false || permissions.dataikerAdmin != null && permissions.dataikerAdmin != false);
            result.mayManageGovern = this.mayManageGovern() || permissions.mayManageGovern();
            return result;
        }

        public static GroupPermissions baseGroupPermissionsForUnion() {
            GroupPermissions gp = new GroupPermissions();
            gp.admin = false;
            gp.dataikerAdmin = null;
            gp.mayManageGovern = false;
            return gp;
        }

        public final boolean hasSameResolvedPermissionsAs(GroupPermissions other) {
            GroupPermissions resolvedThis = this.getResolved();
            GroupPermissions resolvedOther = other.getResolved();
            return resolvedThis.admin == resolvedOther.admin && Objects.equals(resolvedThis.dataikerAdmin, resolvedOther.dataikerAdmin) && resolvedThis.mayManageGovern == resolvedOther.mayManageGovern;
        }

        public boolean mayManageGovern() {
            return this.mayManageGovern || this.admin;
        }

        public void setMayManageGovern(boolean mayManageGovern) {
            this.mayManageGovern = mayManageGovern;
        }

        public GroupPermissions withMayManageGovern(boolean mayManageGovern) {
            this.mayManageGovern = mayManageGovern;
            return this;
        }
    }
}

