/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security.sso;

import com.dataiku.dip.security.sso.SSOUserSupplier;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GHSSOUserSupplier
extends SSOUserSupplier {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");

    @Autowired
    public GHSSOUserSupplier(GeneralSettingsDAO gsDAO, PubSubService pubSubService) {
        this.ssoSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().ssoSettings;
        pubSubService.subscribe("general-settings-changed", evt -> {
            try {
                GeneralSettingsDAO.GeneralSettings generalSettings = gsDAO.getUnsafeAutoTXN();
                this.ssoSettings = generalSettings.ssoSettings;
            }
            catch (IOException e) {
                logger.error((Object)"Could not reload modified general settings", (Throwable)e);
            }
        });
    }
}

